/* matop1.h */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992, 1993, 1994  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#ifndef MATRIX_OP1_H
#define MATRIX_OP1_H

#include "matrix.h"

extern Matrix *matrix_Add _PROTO ((Matrix * ma, Matrix * mb));
extern Matrix *matrix_Sub _PROTO ((Matrix * ma, Matrix * mb));
extern Matrix *matrix_El_Add _PROTO ((Matrix * ma, Matrix * mb));
extern Matrix *matrix_El_Sub _PROTO ((Matrix * ma, Matrix * mb));
extern Matrix *matrix_Multiply _PROTO ((Matrix * ma, Matrix * mb));
extern Matrix *matrix_MultiplyRR _PROTO ((Matrix * ma, Matrix * mb));
extern Matrix *matrix_MultiplyRC _PROTO ((Matrix * ma, Matrix * mb));
extern Matrix *matrix_MultiplyCR _PROTO ((Matrix * ma, Matrix * mb));
extern Matrix *matrix_MultiplyCC _PROTO ((Matrix * ma, Matrix * mb));
extern Matrix *matrix_El_Mul _PROTO ((Matrix * m1, Matrix * m2));
extern Matrix *matrix_El_Div _PROTO ((Matrix * m1, Matrix * m2));
extern Matrix *matrix_Negate _PROTO ((Matrix * m));

extern Matrix *matrix_Abs _PROTO ((Matrix * m));
extern Matrix *matrix_Log _PROTO ((Matrix * m));
extern Matrix *matrix_Log10 _PROTO ((Matrix * m));
extern Matrix *matrix_Logb _PROTO ((Matrix * m));
extern void    matrix_Frexp _PROTO ((Matrix * m, Matrix **f, Matrix **e));
extern Matrix *matrix_Exp _PROTO ((Matrix * m));
extern Matrix *matrix_Sqrt _PROTO ((Matrix * m));

extern Matrix *matrix_Int _PROTO ((Matrix * m));
extern Matrix *matrix_Transpose _PROTO ((Matrix * m));
extern Matrix *matrix_ElTranspose _PROTO ((Matrix * m));

extern Matrix *matrix_Rand _PROTO ((int nrow, int ncol));
extern Matrix *matrix_RandC _PROTO ((int nrow, int ncol));

extern Matrix *matrix_Any _PROTO ((Matrix * m));
extern Matrix *matrix_All _PROTO ((Matrix * m));

extern Matrix *matrix_scalar_add _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_scalar_sub1 _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_scalar_sub2 _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_scalar_mul _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_scalar_div1 _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_scalar_div2 _PROTO ((Matrix * m, Scalar * s));

extern Matrix *matrix_ElOp _PROTO ((Matrix * v, double (*fptr) (),
				    char *fname));

extern Matrix *matrix_eq _PROTO ((Matrix * m1, Matrix * m2));
extern Matrix *matrix_ne _PROTO ((Matrix * m1, Matrix * m2));
extern Matrix *matrix_le _PROTO ((Matrix * m1, Matrix * m2));
extern Matrix *matrix_ge _PROTO ((Matrix * m1, Matrix * m2));
extern Matrix *matrix_lt _PROTO ((Matrix * m1, Matrix * m2));
extern Matrix *matrix_gt _PROTO ((Matrix * m1, Matrix * m2));
extern Matrix *matrix_and _PROTO ((Matrix * m1, Matrix * m2));
extern Matrix *matrix_or _PROTO ((Matrix * m1, Matrix * m2));
extern Matrix *matrix_not _PROTO ((Matrix * m));

extern Matrix *matrix_scalar_eq _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_scalar_ne _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_scalar_gt1 _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_scalar_gt2 _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_scalar_lt1 _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_scalar_lt2 _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_scalar_ge1 _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_scalar_ge2 _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_scalar_le1 _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_scalar_le2 _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_scalar_and _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_scalar_or _PROTO ((Matrix * m, Scalar * s));

extern int do_cmplx _PROTO ((Matrix * m));

#endif /* MATRIX_OP1_h */
