/* fi_2.h */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992, 1994  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#ifndef FI_2_H
#define FI_2_H

#include "matrix.h"

extern Matrix *matrix_LS _PROTO ((Matrix * a, Matrix * b));
extern matrix_Factor_Ge _PROTO ((Matrix * m, Matrix ** lu,
				 Matrix ** pvt, double *cond));
extern matrix_Factor_Sy _PROTO ((Matrix * m, Matrix ** ldl,
				 Matrix ** pvt, double *cond));
extern Matrix *matrix_Backsub _PROTO ((Btree * f, Matrix * b));
extern void matrix_Schur _PROTO ((Matrix * m, Matrix ** t, Matrix ** z));
extern void matrix_Sylv _PROTO ((Matrix *a, Matrix *b, Matrix *c, 
				 Matrix **x));
extern void matrix_Schur_Reorder _PROTO ((Matrix *t, Matrix *z, 
					  int ifst, int ilst, 
					  Matrix **T, Matrix **Q));
#endif /* FI_2__H */
