/* matop2.h */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#ifndef MATRIX_OP2_H
#define MATRIX_OP2_H

#include "matrix.h"
#include "r_string.h"
#include <stdio.h>

extern Matrix *matrix_Real _PROTO ((Matrix * m));
extern Matrix *matrix_Imag _PROTO ((Matrix * m));
extern Matrix *matrix_Conj _PROTO ((Matrix * m));

extern Matrix *matrix_Sin _PROTO ((Matrix * m));
extern Matrix *matrix_Cos _PROTO ((Matrix * m));
extern Matrix *matrix_Tan _PROTO ((Matrix * m));

extern Matrix *matrix_Asin _PROTO ((Matrix * m));
extern Matrix *matrix_Acos _PROTO ((Matrix * m));
extern Matrix *matrix_Atan _PROTO ((Matrix * m));

extern Matrix *matrix_Atan2 _PROTO ((Matrix * m1, Matrix * m2));

extern Matrix *matrix_Sign _PROTO ((Matrix * m));

extern Matrix *matrix_Max _PROTO ((Matrix * m));
extern Matrix *matrix_Maxi _PROTO ((Matrix * m));
extern Matrix *matrix_Min _PROTO ((Matrix * m));
extern Matrix *matrix_Mini _PROTO ((Matrix * m));

extern Matrix *matrix_matrix_Pow _PROTO ((Matrix *m1, Matrix *m2));
extern Matrix *matrix_Pow1 _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_Pow2 _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_matrix_el_pow _PROTO ((Matrix * m1, Matrix * m2));
extern Matrix *matrix_ReadGeneric _PROTO ((FILE * fn, int block_size));
extern Matrix *matrix_WriteGeneric _PROTO ((Matrix * m, FILE * fn));
extern Matrix *matrix_CreateCLoad _PROTO ((Matrix * mr, Matrix * mi));

extern Matrix *matrix_Rdivide _PROTO ((Matrix * m1, Matrix * m2));
extern Matrix *matrix_Ldivide _PROTO ((Matrix * m1, Matrix * m2));

extern void matrix_gt_zero _PROTO ((Matrix * m));

extern Matrix *matrix_Find _PROTO ((Matrix * m));
extern Matrix *matrix_Mod _PROTO ((Matrix * m1, Matrix * m2));

extern VPTR matrix_Sum _PROTO ((Matrix * m));
extern VPTR matrix_Prod _PROTO ((Matrix * m));

extern Matrix *matrix_scalar_Pow1 _PROTO ((Matrix * m, Scalar * s));
extern Matrix *matrix_scalar_Pow2 _PROTO ((Matrix * m, Scalar * s));

extern Matrix *matrix_string_eq _PROTO ((Matrix *, String *));
extern Matrix *matrix_string_ne _PROTO ((Matrix *, String *));
extern Matrix *matrix_string_le1 _PROTO ((Matrix *, String *));
extern Matrix *matrix_string_le2 _PROTO ((Matrix *, String *));
extern Matrix *matrix_string_ge1 _PROTO ((Matrix *, String *));
extern Matrix *matrix_string_ge2 _PROTO ((Matrix *, String *));
extern Matrix *matrix_string_lt1 _PROTO ((Matrix *, String *));
extern Matrix *matrix_string_lt2 _PROTO ((Matrix *, String *));
extern Matrix *matrix_string_gt1 _PROTO ((Matrix *, String *));
extern Matrix *matrix_string_gt2 _PROTO ((Matrix *, String *));
extern Matrix *matrix_string_and _PROTO ((Matrix *, String *));
extern Matrix *matrix_string_or _PROTO ((Matrix *, String *));

extern Matrix *matrix_string_add _PROTO ((Matrix *, String *, int));

extern Matrix *matrix_VectorAddRow _PROTO ((Matrix * m, Matrix * v));
extern Matrix *matrix_VectorAddCol _PROTO ((Matrix * m, Matrix * v));

extern Matrix *matrix_VectorSubRow1 _PROTO ((Matrix * m, Matrix * v));
extern Matrix *matrix_VectorSubCol1 _PROTO ((Matrix * m, Matrix * v));
extern Matrix *matrix_VectorSubRow2 _PROTO ((Matrix * m, Matrix * v));
extern Matrix *matrix_VectorSubCol2 _PROTO ((Matrix * m, Matrix * v));

extern Matrix *matrix_VectorMulRow _PROTO ((Matrix * m, Matrix * v));
extern Matrix *matrix_VectorMulCol _PROTO ((Matrix * m, Matrix * v));

extern Matrix *matrix_VectorDivRow1 _PROTO ((Matrix * m, Matrix * v));
extern Matrix *matrix_VectorDivCol1 _PROTO ((Matrix * m, Matrix * v));
extern Matrix *matrix_VectorDivRow2 _PROTO ((Matrix * m, Matrix * v));
extern Matrix *matrix_VectorDivCol2 _PROTO ((Matrix * m, Matrix * v));

#endif /* MATRIX_OP2_H */
