//-------------------------------------------------------------------//

//  Syntax:	mret ( LIST, a, b, c, d, e, f, g, h )

//  Description:

//  The function mret is provided to allow users to use functions that
//  return multiple arguments in a "MATLAB"-like fashion. Mret stands
//  for Matlab RETurn. Proper usage of mret() is best shown with
//  examples: 

//  In MATLAB you might call eig like:

//	[v,d] = eig (a);

//  Using mret you could:

//	mret (eig (a), v="vec", d="val");

//  The above example assigns the list members that eig() returns to
//  the variables `v', and `d'. The values of the strings determine
//  the mapping between RLaB list elements, and user variable names.

//  The list returned by the 1st argument is destroyed after the
//  assignments are complete.

//  If eight return-element mappings are not enough, mret() can easily
//  be expanded.

//-------------------------------------------------------------------//

mret =  function ( L, a, b, c, d, e, f, g, h )
{
  if (class (L) == "list")
  {
    if (exist (a)) {  a = L.[a]; }
    if (exist (b)) {  b = L.[b]; }
    if (exist (c)) {  c = L.[c]; }
    if (exist (d)) {  d = L.[d]; }
    if (exist (e)) {  e = L.[e]; }
    if (exist (f)) {  f = L.[f]; }
    if (exist (g)) {  g = L.[g]; }
    if (exist (h)) {  h = L.[h]; }
  else
    error ("mret: 1st argument must be a list-object");
  }
  clear (L);
};
