//-------------------------------------------------------------------//
//  set

//  Syntax:	set ( A )

//  Description:

//  The set function takes an vector argument (A), and returns a
//  vector that is sorted in ascending order, and has no duplicate
//  values. 

//  See Also: complement, intersection, union
//-------------------------------------------------------------------//

set = function ( A )
{
  local (a, i, j, s, tmp)

  if (min (size (A)) != 1) {
    error ("set: requires vector argument");
  }

  i = j = 1;
  a = sort (A).val;
  while (i <= a.n)
  {
    tmp = find (a[i] == a);
    if (tmp.n > 1) 
    {
      s[j] = a[tmp[1]];
      i = i + tmp.n;
    else
      s[j] = a[tmp];
      i++;
    }
    j++;
  }
  return s
};
