/* random.h */

/*
 * Defines, and declarations for a 
 * C => Fortran, RLaB => RANLIB interface.
 */

#ifndef RLAB_RANDOM_H
#define RLAB_RANDOM_H

#include "fi.h"

#ifdef HAVE_FORTRAN_UND_BACK

#define SETALL setall_
#define RANF   ranf_
#define GENBET genbet_
#define GENCHI genchi_
#define GENEXP genexp_
#define GENF   genf_
#define GENGAM gengam_
#define GENNCH gennch_
#define GENNF  gennf_
#define GENNOR gennor_
#define GENUNF genunf_
#define IGNBIN ignbin_
#define IGNPOI ignpoi_
#define INITGN initgn_

#endif

#ifdef HAVE_FORTRAN_UND_FRONT

#define SETALL _setall
#define RANF   _ranf
#define GENBET _genbet
#define GENCHI _genchi
#define GENEXP _genexp
#define GENF   _genf
#define GENGAM _gengam
#define GENNCH _gennch
#define GENNF  _gennf
#define GENNOR _gennor
#define GENUNF _genunf
#define IGNBIN _ignbin
#define IGNPOI _ignpoi
#define INITGN _initgn

#endif

#ifdef HAVE_FORTRAN_UPPERCASE
/* Do nothing, the existing code is OK */
#endif

#ifdef HAVE_FORTRAN_LOWERCASE

#define SETALL setall
#define RANF   ranf
#define GENBET genbet
#define GENCHI genchi
#define GENEXP genexp
#define GENF   genf
#define GENGAM gengam
#define GENNCH gennch
#define GENNF  gennf
#define GENNOR gennor
#define GENUNF genunf
#define IGNBIN ignbin
#define IGNPOI ignpoi
#define INITGN initgn

#endif

extern F_INT    SETALL ();
extern F_REAL   RANF ();
extern F_REAL   GENBET ();
extern F_REAL   GENCHI ();
extern F_REAL   GENEXP ();
extern F_REAL   GENF ();
extern F_REAL   GENGAM ();
extern F_REAL   GENNCH ();
extern F_REAL   GENNF ();
extern F_REAL   GENNOR ();
extern F_REAL   GENUNF ();
extern F_INT    IGNBIN ();
extern F_INT    IGNPOI ();
extern F_INT    INITGN ();

#endif  /* RLAB_RANDOM_H */
