/* mem.c */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#include "rlab.h"
#include "mem.h"

/* **************************************************************
 * Check return from malloc. error_1() is coupled with RLaB.
 * If you are using this as part of another package, then replace
 * error_1() with something more suitable for your needs.
 * ************************************************************** */
VPTR
r_malloc (n)
     size_t n;
{
  VPTR p;

  if ((p = malloc (n)) == 0)
    error_1 ("out of memory", (char *) 0);
  return (p);
}

/* **************************************************************
 * Check return from realloc().
 * ************************************************************** */
VPTR
r_realloc (ptr, size)
     VPTR ptr;
     size_t size;
{
  VPTR p;

  if ((p = realloc (ptr, size)) == 0)
    error_1 ("out of memory", (char *) 0);
  return (p);
}

VPTR
xmalloc (n)
     size_t n;
{
  return r_malloc (n);
}

VPTR
xrealloc (ptr, size)
     VPTR ptr;
     size_t size;
{
  return r_realloc (ptr, size);
}
