/* listnode.h */

/*  This file is a part of RLaB ("Our"-LaB)
    Copyright (C) 1992, 1993  Ian R. Searle

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file ./COPYING
 ***********************************************************************/

#ifndef  LIST_NODE_H
#define  LIST_NODE_H

#include "config.h"
#include <stdio.h>
#include <string.h>

typedef struct _listNode ListNode;

struct _listNode
{
  int type;			/* Type of data attached to the listNode       */
  char *key;			/* Key value; Uniquely identifies list_node    */
  VPTR data;			/* Data attached to list_Node_t                */
  void (*dtor) ();		/* Function to free dyn. alloc. mem. in data   */
  int scope;                    /* The variable scope (static or global)       */
  int num;                      /* The relative order of the node              */
  ListNode *next;		/* Pointer to the next ListNode in list        */
  ListNode *prev;		/* Pointer to the previous ListNode in list    */
};

#define BAD_LIST_NODE   (ListNode*) -1

/* ************************************************************************
 * PUBLIC FUNCTIONS
 * ************************************************************************ */

extern ListNode *listNode_Create _PROTO ((void));
extern void listNode_Destroy _PROTO ((ListNode *));
extern int listNode_DestroyNodeOnly _PROTO ((ListNode *));
extern int listNode_DestroyDataOnly _PROTO ((ListNode *));
extern int listNode_AttachAhead _PROTO ((ListNode *, ListNode *));
extern int listNode_AttachBehind _PROTO ((ListNode *, ListNode *));

extern int listNode_Detach _PROTO ((ListNode *));

extern ListNode *listNode_GetNodeAhead _PROTO ((ListNode *));
extern ListNode *listNode_GetNodeBehind _PROTO ((ListNode *));

extern ListNode *listNode_AttachData _PROTO ((ListNode * listNode,
					      int type,
					      VPTR data, void (*freeFn) ()));

extern char *listNode_GetKey _PROTO ((ListNode *));
extern char *e_key _PROTO ((ListNode * lnode));
extern int listNode_SetKey _PROTO ((ListNode *, char *));

extern int listNode_SetNum _PROTO ((ListNode *, int num));
extern int listNode_SetScope _PROTO ((ListNode *, int scope));

extern int listNode_SetType _PROTO ((ListNode *, int type));

/* extern int listNode_IsNodeAttached _PROTO ((ListNode *)); */
#define listNode_IsNodeAttached(lnode) ((lnode->next || lnode->prev) ? 1 : 0)

#define listNode_GetNextNode(lnode)      (lnode->next)
#define listNode_GetPrevNode(lnode)      (lnode->prev)

#define listNode_GetType(a)              (a->type)
#define listNode_GetKey(a)               (((ListNode *) (a))->key)
#define e_key(a)                         (((ListNode *) (a))->key)
#define e_type(a)                        (a->type)	/* shorthand */
#define listNode_GetData(a)              (((ListNode *)(a))->data)
#define e_data(a)                        (a->data)	/* shorthand */
#define e_name(a)                        (a->key)	/* shorthand */
#define listNode_GetScope(a)             (((ListNode *)(a))->scope)
#define listNode_GetNum(a)               (((ListNode *)(a))->num)

#endif /* LIST_NODE_H */
