##############################################################################
#
# Setup macros for a Unix-like system.
# Includes appropriate system config file.
#
# $Id: cf_unix.m4,v 1.15 1994/05/24 20:33:20 mjl Exp $
#
##############################################################################
#
# Compiler/linker macros
#
# The following make variables are used.  They should be redefined as 
# appropriate in the config file for your system.  The default value is
# given in parentheses.
#
# CC		ANSI C compiler (cc)
# F77		Fortran 77 compiler (f77)
# BUILD		Build command for libraries (ar q)
# LIBSUF	Library suffix (a)
# LDC		Linker for C programs ($(CC))
# LDF		Linker for Fortran programs ($(F77))
# LN		Softlink create command (ln -s)
# TO		Flag to specify executable name (-o)
# C		Flag to specify compile only (-c)
# STARTUP	Startup code to link in ()
#
# The following are only set if the appropriate m4 macro is defined,
# otherwise are null.  I need to specify one for each compiler used for
# full generality (on some systems the syntax may differ slightly between
# them).  Each is tagged with:
#
#	_C	for the C compiler
#	_CXX	for the C++ compiler
#	_F	for the Fortran 77 compiler
#	_MPPL	for the MPPL pre-processor
#	_LC	for the C linker
#	_LCXX	for the C++ linker
#	_LF	for the Fortran 77 linker
#
# DEBUG_FLAG	Compile with debugging on
# OPT_FLAG	Compile with optimization on
# DBL_FLAG	Use double-precision
# PROF_FLAG	Compile with profiling on
# SYS_FLAGS	Misc system-specific compiler flags
# SHARE_FLAG	Targeting a shared library
# PROF_FLAG	Link with profiling on
# SYS_FLAGS	Misc system-specific linker flags
# DEBUG_FLAG	Link with debugging on
# EXT_FLAGS	Extra compiler flags (site or application dependent)
#
# The following are tagged with _F, _C, or _C++, depending on which
# compiler is linking the final executable.
#
# LIB		Standard link libraries
# EXT_LIBS	Extra link libraries (site or application dependent)
#
# For the following, only a _F or _C is required since the same linker
# syntax should be used by both the C++ and C compilers.
#
# LIB_X11	Link libraries for X11
# LIB_TK	Link libraries for Tcl/TK
#
# Most of these are not explicitly set, and thereby default to the null
# string. 
#
##############################################################################

define({UNIX},)dnl

# Defaults

CC		= cc
CXX		= CC
F77		= f77
MPPL		= mppl
M4		= m4
BUILD		= ar q
LIBSUF		= a
LDC		= $(CC)
LDCXX		= $(CXX)
LDF		= $(F77)
LN		= ln -s
TO		= -o
C	 	= -c
STARTUP 	=

SYS_FLAGS_CXX	= +a1

LIB_C		= -lm
LIB_CXX		= -lm
LIB_F		= -lm
LIB_F2C		=
LIB_X11_C	= -lX11
LIB_X11_F	= -lX11
LIB_TK_C	= $(TK_LIBDIR) -ltk -ltcl
LIB_TK_F	= $(TK_LIBDIR) -ltk -ltcl
LIB_DP_C	= $(TK_LIBDIR) -ldpnetwork
LIB_DP_F	= $(TK_LIBDIR) -ldpnetwork
LIB_ITCL_C	= $(TK_LIBDIR) -litcl
LIB_ITCL_F	= $(TK_LIBDIR) -litcl

# Flag used in updating the makefile
# I make this an m4 macro so it can reference itself in its definition.

define({MAKE_FLAGS}, -DSYSTEM=SYSTEM)

# Now turn on options.

# Use gcc

if_gcc({
CC = gcc
define({MAKE_FLAGS}, MAKE_FLAGS -DGCC)
})

# Use f2c
# This assumes a different name than "f77" since you may have both.
# You can always make a link from "f77" to "fc" to handle this.

if_f2c({
F77 = fc
LIB_F2C = -lf2c
define({MAKE_FLAGS}, MAKE_FLAGS -DF2C)
})

# Debugging

if_debug({
DEBUG_FLAG_C	= -g
DEBUG_FLAG_CXX	= -g
DEBUG_FLAG_F	= -g
DEBUG_FLAG_LC	= -g
DEBUG_FLAG_LCXX	= -g
DEBUG_FLAG_LF	= -g
define({MAKE_FLAGS}, MAKE_FLAGS -DDEBUG)
})

# Warnings.  This is too system specific to go here, but I can at least
# set MAKE_FLAGS accordingly.

if_warn({
define({MAKE_FLAGS}, MAKE_FLAGS -DWARN)
})

# Optimization

if_opt({
OPT_FLAG_C	= -O
OPT_FLAG_CXX	= -O
OPT_FLAG_F	= -O
define({MAKE_FLAGS}, MAKE_FLAGS -DOPT)
})

# Double precision
# Note there is no "standard" way to invoke double precision in Fortran
# from the command line, although several systems do provide a way (see
# sections for SUNOS, A/IX).

if_dbl({
DBL_FLAG_C	= -DDOUBLE
DBL_FLAG_CXX	= -DDOUBLE
DBL_FLAG_M4	= -DDOUBLE
DBL_FLAG_F      =
DBL_FLAG_MPPL	= -dDOUBLE=TRUE
define({MAKE_FLAGS}, MAKE_FLAGS -DDOUBLE)
})

# Profiling
# Not a good default for Fortran here, either.

if_prof({
PROF_FLAG_C	= -p
PROF_FLAG_CXX	= -p
PROF_FLAG_LC	= -p
define({MAKE_FLAGS}, MAKE_FLAGS -DPROF)
})

# Extras

if_shr(,{
define({MAKE_FLAGS}, MAKE_FLAGS -DNO_SHARE)
})

if_xwin(,{
define({MAKE_FLAGS}, MAKE_FLAGS -DNO_X)
})

if_tk(,{
define({MAKE_FLAGS}, MAKE_FLAGS -DNO_TK)
})

ifdef({MACHINE},{
define({MAKE_FLAGS}, MAKE_FLAGS -DMACHINE=MACHINE)
})

ifdef({PREFIX},{
define({MAKE_FLAGS}, MAKE_FLAGS -DPREFIX=PREFIX)
})

##############################################################################
#
# Include config file
#
##############################################################################

if_sunos(	{include(cf_sun.m4)})
if_hpux(	{include(cf_hp.m4)})
if_sysv(	{include(cf_sysv.m4)})
if_irix(	{include(cf_irix.m4)})
if_sx(		{include(cf_sx.m4)})
if_dgux(	{include(cf_dgux.m4)})
if_linux(	{include(cf_linux.m4)})
if_next(	{include(cf_next.m4)})
if_aix(		{include(cf_aix.m4)})
if_unicos(	{include(cf_cray.m4)})
if_alphaosf(	{include(cf_alpha.m4)})
if_convex(      {include(cf_convex.m4)})

##############################################################################

# Final compiler flags

CC_FLAGS= $(C) $(DBL_FLAG_C) $(DEBUG_FLAG_C) $(OPT_FLAG_C) \
	  $(SYS_FLAGS_C) $(PROF_FLAG_C) $(SHARE_FLAG_C) \
	  -I. $(INC_DIR_C) $(EXT_FLAGS_C)

CXX_FLAGS= $(C) $(DBL_FLAG_CXX) $(DEBUG_FLAG_CXX) $(OPT_FLAG_CXX) \
	   $(SYS_FLAGS_CXX) $(PROF_FLAG_CXX) $(SHARE_FLAG_CXX) \
	   -I. $(INC_DIR_C) $(EXT_FLAGS_CXX)

F77_FLAGS= $(C) $(DBL_FLAG_F) $(DEBUG_FLAG_F) $(OPT_FLAG_F) \
	   $(SYS_FLAGS_F) $(PROF_FLAG_F) $(SHARE_FLAG_F) $(EXT_FLAGS_F)

M4_FLAGS= -S2000 -B8192 -DSYSTEM=SYSTEM $(DBL_FLAG_M4)

MPPL_FLAGS= -f -b $(DBL_FLAG_MPPL) $(INC_DIR_MPPL) $(SYS_FLAGS_MPPL)

# These make it a bit easier to deal with bogus optimizers

CC_FLAGS_NOOPT= $(C) $(DBL_FLAG_C) $(DEBUG_FLAG_C) \
	   $(SYS_FLAGS_C) $(PROF_FLAG_C) $(SHARE_FLAG_C) \
	   -I. $(INC_DIR_C) $(EXT_FLAGS_C)

CXX_FLAGS_NOOPT= $(C) $(DBL_FLAG_CXX) $(DEBUG_FLAG_CXX) \
	   $(SYS_FLAGS_CXX) $(PROF_FLAG_CXX) $(SHARE_FLAG_CXX) \
	   -I. $(INC_DIR_C) $(EXT_FLAGS_CXX)

F77_FLAGS_NOOPT= $(C) $(DBL_FLAG_F) $(DEBUG_FLAG_F) \
	   $(SYS_FLAGS_F) $(PROF_FLAG_F) $(SHARE_FLAG_F) $(EXT_FLAGS_F)

# Final linker flags
# Take care of blowing away X-windows and/or TK here.

if_xwin(,{
LIB_X11_C	=
LIB_X11_F	=
})

if_tk(,{
LIB_TK_C	=
LIB_TK_F	=
})

if_dp(,{
LIB_DP_C	=
LIB_DP_F	=
})

if_itcl(,{
LIB_ITCL_C	=
LIB_ITCL_F	=
})

LDC_FLAGS =   $(PROF_FLAG_LC) $(SYS_FLAGS_LC) $(DEBUG_FLAG_LC) \
		$(EXT_FLAGS_LC)

LDCXX_FLAGS = $(PROF_FLAG_LCXX) $(SYS_FLAGS_LCXX) $(DEBUG_FLAG_LCXX) \
		$(EXT_FLAGS_LCXX)

LDF_FLAGS =   $(PROF_FLAG_LF) $(SYS_FLAGS_LF) $(DEBUG_FLAG_LF) \
		$(EXT_FLAGS_LF)

LDC_LIBS   = $(LIB_F2C) $(LIB_TK_C) $(LIB_DP_C) $(LIB_ITCL_C) \
		$(LIB_X11_C) $(LIB_C) \
		$(EXT_LIBS_C)
LDCXX_LIBS = $(LIB_F2C) $(LIB_TK_C) $(LIB_DP_C) $(LIB_ITCL_C) \
		$(LIB_X11_C) $(LIB_CXX) \
		$(EXT_LIBS_CXX)
LDF_LIBS   = $(LIB_F2C) $(LIB_TK_F) $(LIB_DP_F) $(LIB_ITCL_C) \
		$(LIB_X11_F) $(LIB_F) \
		$(EXT_LIBS_F)

# Define tags to be used in multiple-precision library names
#
# Single precision: tag with "f"
# Double precision: tag with "d"

if_dbl({
TAG_PREC	= d
},{
TAG_PREC	= f
})

##############################################################################
#
# Set up inference rules
#
##############################################################################

# Clear the suffix list, to avoid any possible problems with funny suffixes.
# I can add them back as necessary.

.SUFFIXES:

# The order here is important.  
# If the C++ compiler doesn't like .cc file suffixes, define CXX_PREFER_CSUF.

.SUFFIXES: .o .cc .c .p .f .q .h .i .ccm4 .cm4 .pm4 .fm4 .hm4 .im4

.c.o:
	$(CC) $(CC_FLAGS) $*.c

ifdef({CXX_PREFER_CSUF},{
.cc.o:
	-@ln -s $*.cc $*.C
	$(CXX) $(CXX_FLAGS) $*.C
},{
.cc.o:
	$(CXX) $(CXX_FLAGS) $*.cc
})

.p.o:
	$(MPPL) $(MPPL_FLAGS) $*.p >$*.f
	$(F77) $(F77_FLAGS) $*.f

ifdef({FORTRAN_COMP_RULE},
FORTRAN_COMP_RULE,
.f.o:
	$(F77) $(F77_FLAGS) $*.f
)

.q.o:
	$(MPPL) $(MPPL_FLAGS) $*.q >$*.f
	$(F77) $(F77_FLAGS) $*.f

.hm4.h:
	$(M4) $(M4_FLAGS) $< >$*.h

.im4.i:
	$(M4) $(M4_FLAGS) $< >$*.i

.ccm4.cc:
	$(M4) $(M4_FLAGS) $< >$*.cc

.cm4.c:
	$(M4) $(M4_FLAGS) $< >$*.c

.pm4.p:
	$(M4) $(M4_FLAGS) $< >$*.p

.fm4.f:
	$(M4) $(M4_FLAGS) $< >$*.f
