##############################################################################
#
#		LINUX definitions
#
# $Id: cf_linux.m4,v 1.4 1994/05/12 17:13:54 furnish Exp $
#
##############################################################################

CC	= gcc
F77	= f77	# script front-end to f2c

define({FORTRAN_COMP_RULE},{
.f.o:
	f2c -c ${*}.f
	$(CC) $(CC_FLAGS) ${*}.c
})

LIB_C	= -ansi -lm -lc

define({SYSTEM_AUX_TARGETS},

# Beginnings of support for Linux DLL.  This is NOT done yet.  If you
# know what you're doing better than me, you might lend a hand.

JUMP_DIR := $(HOME)/pljump
JUMP_LIB := libplplotftk
JIMP	 := $(JUMP_DIR)/jump.import

LOAD_ADDR  := -a 0x77000000
DATA_SEG   :=
IMAGE_NAME := -l $(HOME)/lib/libplplotftk
IMAGE_VER  := -v 5.0
JMP_TAB_SZ := -j 0x4000
GOT_SIZE   := -g 0x1000

dll:
	@echo "Building DLL libs for Linux..."
# Start by cleaning the slate
	-rm *.o
	-rm -rf $(JUMP_DIR)
	-mkdir $(JUMP_DIR)
	$(MAKE) libs "CC_FLAGS=$(CC_FLAGS) -B/usr/dll/jump/"
# Okay, now get the vars and funcs.
	(cd $(JUMP_DIR); /usr/dll/bin/getvars)
	(cd $(JUMP_DIR); /usr/dll/bin/getfuncs)
	-rm $(JUMP_DIR)/jump.log
# Alright, now create the jump.import file  What fun.
	nm --no-cplus -o /usr/lib/libc.sa | grep __GOT_ | sed 's/__GOT__/_/' > $(JIMP)
	nm --no-cplus -o /usr/lib/libm.sa | grep __GOT_ | sed 's/__GOT__/_/' >> $(JIMP)
	nm --no-cplus -o /usr/lib/libtcl.sa | grep __GOT_ | sed 's/__GOT__/_/' >> $(JIMP)
	nm --no-cplus -o /usr/lib/libtk.sa | grep __GOT_ | sed 's/__GOT__/_/' >> $(JIMP)
	nm --no-cplus -o /usr/lib/libitcl.sa | grep __GOT_ | sed 's/__GOT__/_/' >> $(JIMP)
	nm --no-cplus -o /usr/lib/libX11.sa | grep __GOT_ | sed 's/__GOT__/_/' >> $(JIMP)
# Step 5: recompile again..
	-rm *.o
	$(MAKE) libs "CC_FLAGS=$(CC_FLAGS) -B/usr/dll/jump/"
	(cd $(JUMP_DIR); /usr/dll/bin/getsize > jump.vars-new)
# Step 6, build the libs
	/usr/dll/bin/mkimage $(IMAGE_NAME) $(LOAD_ADDR) $(DATA_SEG) \
		$(GOT_SIZE) $(JMP_TAB_SZ) -- *.o \
		-lf2c -ltk -ltcl -litcl -lX11 -lm -lc
	/usr/dll/bin/mstubs  $(IMAGE_NAME) $(LOAD_ADDR) $(DATA_SEG) \
		$(GOT_SIZE) $(JMP_TAB_SZ) -- libplplotftk

# Unfinished.
	@echo "Have a happy day."
)
