##############################################################################
#
#		HP-UX definitions
#
# $Id: cf_hp.m4,v 1.6 1994/05/14 05:46:13 mjl Exp $
#
##############################################################################

F77		= fort77

# For OPT=2, use maximum optimization available (HP compiler only).
# HP's optimizing preprocessor has not always been reliable for me, so use
# at your own risk.

ifelse(OPT,2,{
if_gcc(,
OPT_FLAG_C	= +O3 +OS
OPT_FLAG_F	= +O3 +OS +OP
)})

# If gcc is used, don't ask for a shared library.

if_gcc({
define({NO_SHARE},)
},{
CC	= c89
})

# When WARN is defined, most or all warnings are enabled.
# Also use the following:
#    -z		turns off run-time dereferencing of NULL pointers (ld option)
#    +ESlit	puts const data and strings in read-only memory (c89 option)

if_warn({
SYS_FLAGS_LC	= -z
if_gcc({
SYS_FLAGS_C	= -Wall
},{
SYS_FLAGS_C	= +w1 +ESlit
})
},{
SYS_FLAGS_F	= -w
})

# Or if profiling is used, don't go shared.

if_prof({
define({NO_SHARE},)
})

# Double precision -- use auto promotion.  This works only under 9.x --
# the 8.x Fortran compiler only has -R8, which promotes only constants and
# not variables.  You can use a macro for real or different sets of
# sources to get both single and double, though, and in fact I do this
# with the stub interface (for a bit more portability).  So if your
# Fortran compiler doesn't support promotion of real constants AND
# variables, the library will still build, but you won't be able to build
# the Fortran example programs in double precision.

if_dbl({dnl
DBL_FLAG_F      = +autodblpad
})dnl

# Profiling

if_prof({
PROF_FLAG_C	= -G
PROF_FLAG_F	= -G
PROF_FLAG_LC	= -G
PROF_FLAG_LF	= -G
})

# I wish building shared libraries were always this easy..

if_shr({
BUILD		= ld -b -o
LIBSUF		= sl
SHARE_FLAG_C	= +z
SHARE_FLAG_F	= +z
})
