#include <stdio.h>
#include "tools.h"
#include "comm/comm.h"

double ring_sync();
double ring_force();
double ring_async();

/* 
   This is an example or ring communication using several approaches.
   This ring implements a "bucket brigade", each node sends a data item
   around in a ring.
 */

int worker( argc, argv )
int  argc;
char **argv;
{
int    buf, siz = sizeof(int);
int    left, right;
long   reps,proc1,proc2,len,error_flag,distance_flag,distance;
double t, (*f)();
long   first,last,incr, svals[3];

/* Get parameters */
SYusc_init();

if (SYArgHasName( &argc, argv, 1, "-help" )) {
  if (MYPROCID != 0) return 0;
  fprintf( stderr, "%s - test ring speeds\n", argv[0] );
  fprintf( stderr, "[-sync | -async | -force] [-size start end stride]\n" );
  fprintf( stderr, "[-reps n]\n" );
  return 0;
  }

reps          = 100;
error_flag    = 0;
f             = ring_sync;
svals[0]      = 0;
svals[1]      = 1024;
svals[2]      = 32;

if (SYArgHasName( &argc, argv, 1, "-force" ))     f = ring_force;
if (SYArgHasName( &argc, argv, 1, "-async" ))     f = ring_async;
if (SYArgHasName( &argc, argv, 1, "-sync"  ))     f = ring_sync;
SYArgGetIntVec( &argc, argv, 1, "-size", 3, svals );
SYArgGetInt(    &argc, argv, 1, "-reps", &reps );
first = svals[0];
last  = svals[1];
incr  = svals[2];

left  = PSNbrRing( -1, 1, ALLPROCS );
right = PSNbrRing(  1, 1, ALLPROCS );

time_function( reps, first, last, incr, left, right, f);
}

time_function(reps,first,last,incr, left, right, f)
long reps,first,last,incr,left, right;
double (* f)();
{
  long len,myproc;
  double mean_time,rate;
  double t;

  myproc   = MYPROCID;
  if (myproc == 0) 
      printf( "\n#\tdist\tlen\ttime\t\tave time (us)\trate\n");

  for(len=first;len<=last;len+=incr){
    GSYNC( ALLPROCS );
    t = (* f) (reps,len,left, right);
    mean_time = t;
    mean_time = mean_time / reps;            /* take average over trials */
    mean_time = mean_time * (1e6);         /* convert to microseconds */
    rate      = (double)(len)/(mean_time*(1e-6));
    if(myproc==0) printf("\t%d\t%d\t%f\t%f\t%.2f\n",
                              NUMNODES,len,t,mean_time,rate);
  }
}

double ring_sync( reps, len, left, right )
int reps, len, left, right;
{
double elapsed_time;
long i,msg_id,myproc;
char *sbuffer,*rbuffer;
SYusc_time_t t0, t1;

MSGALLOCSEND(sbuffer,len,char);
MSGALLOCRECV(rbuffer,len,char);

PIgsync(ALLPROCS);
if (MYPROCID == 0) {
    PIbrecvm(0,rbuffer,len,MSG_OTHER);
    }
else if (MYPROCID == 1) {
    PIbsendm(0,sbuffer, 0, 0, MSG_OTHER );
    }
SYusc_clock(&t0);
for(i=0;i<reps;i++){
    PIbsendm( 1, sbuffer, len, right, MSG_OTHER );
    PIbrecvm( 1, rbuffer, len, MSG_OTHER );
    }
SYusc_clock(&t1);
elapsed_time = SYuscDiff( &t0, &t1 );

MSGFREESEND(sbuffer);
MSGFREERECV(rbuffer);
return(elapsed_time);
}

double ring_async( reps, len, left, right )
int reps, len, left, right;
{
double elapsed_time;
long i,msg_id,myproc;
char *sbuffer,*rbuffer;
SYusc_time_t t0, t1;
ASYNCRecvId_t  rid;
ASYNCSendId_t  sid;

MSGALLOCSEND(sbuffer,len,char);
MSGALLOCRECV(rbuffer,len,char);

PIgsync(ALLPROCS);
if (MYPROCID == 0) {
    PIbrecvm(0,rbuffer,len,MSG_OTHER);
    }
else if (left == 0) {
    PIbsendm(0,sbuffer, 0, 0, MSG_OTHER );
    }
SYusc_clock(&t0);
for(i=0;i<reps;i++){
    PInrecv( 1, rbuffer, len, MSG_OTHER, rid );
    PInsend( 1, sbuffer, len, right, MSG_OTHER, sid );
    PIwrecv( 1, rbuffer, len, MSG_OTHER, rid );
    PIwsend( 1, sbuffer, len, right, MSG_OTHER, sid );
    }
SYusc_clock(&t1);
elapsed_time = SYuscDiff( &t0, &t1 );

MSGFREESEND(sbuffer);
MSGFREERECV(rbuffer);
return(elapsed_time);
}

double ring_force( reps, len, left, right )
int reps, len, left, right;
{
double elapsed_time;
long i,msg_id,myproc;
char *sbuffer,*rbuffer, buf;
SYusc_time_t t0, t1;
ASYNCRecvId_t  rid;
ASYNCSendId_t  sid;

MSGALLOCSEND(sbuffer,len,char);
MSGALLOCRECV(rbuffer,len,char);

PIgsync(ALLPROCS);
if (MYPROCID == 0) {
    PIbrecvm(0,rbuffer,len,MSG_OTHER);
    }
else if (left == 0) {
    PIbsendm(0,sbuffer, 0, 0, MSG_OTHER );
    }
SYusc_clock(&t0);
for(i=0;i<reps;i++){
    PInrecvrr( 1, rbuffer, len, MSG_OTHER, rid );      /* post receive */
    PIbsendm( 0, sbuffer, 0, left, MSG_OTHER );        /* notify predecessor */
    PIbrecv( 0, &buf, 0, MSG_OTHER );                  /* wait for successor */
    PInsendrr( 1, sbuffer, len, right, MSG_OTHER, sid );
                                                       /* send data */
    PIwrecvrr( 1, rbuffer, len, MSG_OTHER, rid );      /* wait for receive */
    PIwsendrr( 1, sbuffer, len, right, MSG_OTHER, sid ); 
                                                       /* wait for send */
    }
SYusc_clock(&t1);
elapsed_time = SYuscDiff( &t0, &t1 );

MSGFREESEND(sbuffer);
MSGFREERECV(rbuffer);
return(elapsed_time);
}
