#ifndef lint
static char SCCSid[] = "@(#) ./comm/daemon.c 07/23/93";
#endif

#include <stdio.h>
#include <time.h>
#if !defined(__MSDOS__)
#include <sys/param.h>
#endif
#include <string.h>

#include "tools.h"
#include "comm/hosts.h"

/*
   This file contains driver code to start a "daemon" to run parallel
   programs, for those systems the require one.  The code here handles
   accessing the files that describe the hosts and the resource limits;
   it generates a "standard" form that the individual implementations can
   use to start daemons (pvm and p4 are currently the only such implementations

   The databases:
   There are two databases, both files whose names are environment
   variables.  These are TOOLSHOSTS, a database of all machines and
   resource limits (see hosts.c), and <COMM>HOSTS, a list of machines
   (The names must exactly match those in TOOLSHOSTS).
 */

/*
   Merge databases - given the list of hosts that a daemon SHOULD be running
   and the TOOLSHOSTS list, create an in-core list of hosts that the
   resource limiting and architecture selection code can use.

   Algorithm:
   Sort the hostname in the htable and sort the hostnames.
   Then do a simple merge.
 */
int PIHcompare( s1, s2 )
Host *s1, *s2;
{
return strcmp( s1->name, s2->name );
}

void PIMergeHostTable( htable, nh, hostnames )
HostTable *htable;
int       nh;
char      **hostnames;
{
int i1, i2, j2, n1, n2, sgn;

qsort( (char *)(htable->hosts), htable->ne, sizeof(Host *), 
       (int (*)())PIHcompare );
qsort( (char *)hostnames, nh, sizeof(char *), (int (*)())strcmp );
i1 = 0;
i2 = 0;
j2 = 0;
n1 = nh;
n2 = htable->ne;
while (i1 < n1 && i2 < n2) {
    sgn = strcmp( hostnames[i1], htable->hosts[i2]->name );
    if (sgn == 0) {
	/* Accept the host */
	htable->hosts[j2++] = htable->hosts[i2++];
	i1++;
	}
    else if (sgn > 0) {
	i2++;
	/* Should free this host entry */
	}
    else {
	i1++;
	}
    }
}
