#ifndef lint
static char SCCSid[] = "@(#) ./blkcm/defn/default.c 07/23/93";
#endif

/*
    This file contains routines to pick the "default" routines for
    executing a program.  A specific set may be selected (without
    loading the others) by using the routines in ....
 */

#include "blkcm/bc.h"
#include "blkcm/bcp.h"

static int (*DefIsend)() = 0, (*DefIrecv)() = 0, (*DefIwait)() = 0;

/*@
   BCSetDefaultExec - set the routines used to execute a BlockComm program.
   If the pointer it null, the default will be used.

   Input Parameters:
.  irecv - routine to call to set up receives
.  isend - routine to call to send data
.  iwait - routine to call to wait for and process receives
@*/
void BCSetDefaultExec( irecv, isend, iwait )
int (*irecv)(), (*isend)(), (*iwait)();
{
if (irecv) DefIrecv = irecv;
if (isend) DefIsend = isend;
if (iwait) DefIwait = iwait;
}

/*@
  BCSetDefault - Set the default values for a program

  Input Parameter:
. Program - program to set the default values for

  Notes:
  The default values include the default routines to perform such activities
as compiling and executing a program, and moving data from one buffer to 
another.
@*/
void BCSetDefault( Program )
BCPGM *Program;
{
#ifdef DISTRIBUTED_MEMORY
extern int     BCisend(), BCiwait(), 
               BCdobuffer(), BCset_pair_sync(),
               BCset_types(), BCfind_owner(), BCvalid_pgm(),
               BCSortSends();
extern BCb_to_d5d(), BCs_to_b5d();
#endif
extern int BCirecv(), BCcompile(), BCsort_phase(),
               BCtrim_moves(), BCfind_local(), BCvalid_local_pgm();
extern BCs_to_d5d(), BCerror();
extern double *BCDefaultAddress();

Program->sort      = BCsort_phase;
Program->irecv     = DefIrecv ? DefIrecv : BCirecv;
Program->compile   = BCcompile;
Program->findlocal = BCfind_local;
Program->trimmove  = BCtrim_moves;
Program->valid     = BCvalid_local_pgm;
/* getline set in BCalloc */

#ifdef DISTRIBUTED_MEMORY
Program->valid     = BCvalid_pgm;
Program->schedule  = BCSortSends;
Program->isend     = DefIsend ? DefIsend : BCisend;
Program->iwait     = DefIwait ? DefIwait : BCiwait;
Program->settypes  = BCset_types;
Program->findowner = BCfind_owner;
Program->inplace   = 0;
Program->buffer    = BCdobuffer;
Program->pairsync  = BCset_pair_sync;
Program->in        = BCb_to_d5d;
Program->out       = BCs_to_b5d;
#endif 
Program->Error     = BCerror;
Program->copy      = BCs_to_d5d;
/* Set the default address functions */
Program->GetAddressSrc  = BCDefaultAddress;
Program->GetAddressDest = BCDefaultAddress;
}
