
#include <stdio.h>
#include "tools.h"
#include "xtools/basex11.h"
#include "xtools/vfp/windesign.h"
#include "xtools/vfp/message.h"
#include "xtools/baseclr.h"


int* VFPMakeRoute( ) ;
int VFPSetMsgColor( ) ; 

#define SIZE  10 
#define WAIT 1
#define SEND 2
#define REC  3
#define WORK 4


/* some stipples, (most not very good) */
char grey[] = {
   0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55};
char ltgrey[] = {
   0x00, 0x55, 0x00, 0x55, 0x00, 0x55, 0x00, 0x55};
char white[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
char black[] = {
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};


int main( argc, argv )
  int    argc ; 
  char **argv ;
{
  unsigned int  width,
                height ;
  int           px, py;
  XBWindow      *XBWin ;
  XBFont        font ;
  VFPInfo       *info ;
  XB3DBoxStruct *Box1,
                *Box2 ; 
  Pixmap        pix1,
                pix2 ;         
  PixVal        pixval1,
                pixval2 ;

  XBTextBoxStruct *text_info ;
  XBWin = XBWinCreate();

  width = 500 ;
  height = 500 ;
  px = -1;
  py = -1;
  XBGetArgs( &argc, argv, 1, &px, &py, &width, &height );

  if (XBOpenDisplay( XBWin, "" )) {
      fprintf( stderr, "***Could not open display***\n" );
      return 1;
      }
  if (XBSetVisual( XBWin, 1, 0 )) 
    fprintf( stderr, "***Could not set visual to default***\n" );
/*
  XBWin->cmap = (Colormap)0 ;
  XBInitColors( XBWin ) ;
*/
  if (XBOpenWindow( XBWin )) 
    fprintf( stderr, "***Could not open the window***\n" );
  if (XBDisplayWindow( XBWin, "Message Display", px, py, width, height, 0 )) 
    fprintf( stderr, "***Could not display window***\n" );
  XBSetGC( XBWin, XBWin->cmapping[1] );

  XBInitFonts( XBWin ) ;
  XBMatchFontSize( &font, 9, 15 ) ;
  XBLoadFont( XBWin, &font ) ;  

/**** IS THIS NECESSARY?,  SEEMS TO BE THE ONLY WAY TO GET FONTS TO WORK ****/
  {
    XGCValues  values ;
    values.font = font.fnt ;
    XChangeGC( XBWin->disp, XBWin->gc.set, GCFont, &values ) ; 
  }

  info = VFPInit( XBWin, &font, 15, 30, 30, 50, 100 ) ;
  VFPFillProcCoordTree( info, width-110, height-155) ;

/**************/

  pix1 = XCreatePixmapFromBitmapData(XBWin->disp, XBWin->win, 
      ltgrey, 8, 8, 1, 0, 1);  
  pix2 = XCreatePixmapFromBitmapData(XBWin->disp, XBWin->win, 
      white, 8, 8, 1, 0, 1);  

  XBFindColor( info->XBWin, "lavender", &pixval1 );
  XBFindColor( info->XBWin, "white", &pixval2 );

  Box1 = (XB3DBoxStruct*)XBInit3DBox( 1, 1, height-5, width-5, 5, 1, pix1, 
	     pixval1 ) ;
  Box2 = (XB3DBoxStruct*)XBInit3DBox( 50, 100, height-155, width-105, 3, 0, pix2,
             pixval2 ) ;
  XBDraw3DBox( XBWin, Box1 ) ;
  XBDraw3DBox( XBWin, Box2 ) ;
  XBFree3DBox( Box1 ) ;  
  XBFree3DBox( Box2 ) ; 

  text_info = (XBTextBoxStruct*)XBInitTextBox( 50, 35, width-105, 30, CENTER, 
      "Processor - State & Message Display" ) ;
  XBDrawTextBox( XBWin, &font, text_info ) ;
  XBFreeTextBox( text_info ) ;

  VFPDrawProcRects( info ) ;

#if 0
  *** SOME COLOR VALUES ***
  red[0] = 230 ; green[0] = 230 ; blue[0] = 250 ; /* lavender */
  red[0] = 65 ; green[0] = 105 ; blue[0] = 225 ;  /* royal blue */
  red[0] = 0 ; green[0] = 100 ; blue[0] = 0 ;     /* dark green */
  red[0] = 255 ; green[0] = 0 ; blue[0] = 0 ;     /* red */
  red[0] = 0 ; green[0] = 139 ; blue[0] = 139 ;   /* cyan4 */
#endif

/* 0-use current, 1-use default, 2-allocate basic*/


  if( VFPSetMsgColor( info, 65, 105, 225, SIZE, 0 ) )
    /**** error handeling should be here ****/
    printf( "**** did not set message color correctly ****\n") ;


  VFPDoDemo( info ) ;

/*
  ArrowTest( info ) ; 
*/


  VFPFree( info ) ;

  /* getchar(); */
  sleep(5);

} /* end of main procedure */




VFPDoDemo( info )
  VFPInfo      *info ;
{
/* Demo to changes states */
  int           i,j,
               *route ;
  Pixmap        pixmap1,
                pixmap2, pixmap3, pixmap4 ;
  XBWindow     *XBWin=info->XBWin ;

/***********/
  pixmap1 = XCreatePixmapFromBitmapData(XBWin->disp, XBWin->win, 
      grey, 8, 8, 1, 0, 1);  
  pixmap2 = XCreatePixmapFromBitmapData(XBWin->disp, XBWin->win, 
      ltgrey, 8, 8, 1, 0, 1);  
  pixmap3 = XCreatePixmapFromBitmapData(XBWin->disp, XBWin->win, 
      black, 8, 8, 1, 0, 1);  
  pixmap4 = XCreatePixmapFromBitmapData(XBWin->disp, XBWin->win, 
      grey, 8, 8, 1, 0, 1);  
  VFPDefineStateBW( info, 1, pixmap1 );
  VFPDefineStateBW( info, 2, pixmap2 );
  VFPDefineStateBW( info, 3, pixmap3 );
  VFPDefineStateBW( info, 4, pixmap4 );

  VFPDefineStateColor( info, 0, "gray" );
  VFPDefineStateColor( info, WAIT, "red" );
  VFPDefineStateColor( info, SEND, "blue" );
  VFPDefineStateColor( info, WORK, "green" );
  VFPDefineStateColor( info, REC, "yellow" );


  for( i=0 ; i<info->num_processors ; i++ )
    {
      VFPSetState( info, i, WORK ) ; 
    }

  VFPDrawConnection( info, 7, 3, 2 ) ;
  VFPDrawConnection( info, 3, 1, 2 ) ;
  VFPDrawConnection( info, 1, 4, 2 ) ;
  VFPSetState( info, 7, SEND ) ;
  VFPSetState( info, 4, REC ) ;
  
  VFPDrawConnection( info, 5, 12, 5 ) ;
  VFPSetState( info, 5, SEND ) ;
  VFPSetState( info, 12, REC ) ;
  
  VFPDrawConnection( info, 0, 2, 0 ) ;
  VFPDrawConnection( info, 2, 6, 0 ) ;
  VFPSetState( info, 0, SEND ) ;
  VFPSetState( info, 6, REC ) ;

  VFPSetState( info, 14, WAIT ) ;
  VFPSetState( info, 10, WAIT ) ;

}




ArrowTest( info ) 
     VFPInfo  *info ;
{
  XBWindow  *XBWin = info->XBWin ;


  XSetFillStyle( XBWin->disp, XBWin->gc.set, FillSolid );

  XSetForeground( XBWin->disp, XBWin->gc.set, XBWin->foreground ) ;

  /* Diagonal Lines */
  XDrawLine( XBWin->disp, XBWin->win, XBWin->gc.set, 50, 100, 100, 50 ); 
  VFPDrawArrow( info, 50, 100, 100, 50, 10 ) ;
  XDrawLine( XBWin->disp, XBWin->win, XBWin->gc.set, 200, 100, 150, 50 ); 
  VFPDrawArrow( info, 200, 100, 150, 50, 10 ) ;
  XDrawLine( XBWin->disp, XBWin->win, XBWin->gc.set, 50, 150, 100, 200 ); 
  VFPDrawArrow( info, 50, 150, 100, 200, 10 ) ;
  XDrawLine( XBWin->disp, XBWin->win, XBWin->gc.set, 200, 150, 150, 200 ); 
  VFPDrawArrow( info, 200, 150, 150, 200, 10 ) ;
  /* Horizontal Lines */
  XDrawLine( XBWin->disp, XBWin->win, XBWin->gc.set, 100, 115, 150, 115 ); 
  VFPDrawArrow( info, 100, 115, 150, 115, 10 ) ;
  XDrawLine( XBWin->disp, XBWin->win, XBWin->gc.set, 150, 135, 100, 135 ); 
  VFPDrawArrow( info, 150, 135, 100, 135, 10 ) ;
  /* Vertical Lines */
  XDrawLine( XBWin->disp, XBWin->win, XBWin->gc.set, 75, 150, 75, 100 ); 
  VFPDrawArrow( info, 75, 150, 75, 100, 10 ) ;
  XDrawLine( XBWin->disp, XBWin->win, XBWin->gc.set, 175, 100, 175, 150 ); 
  VFPDrawArrow( info, 175, 100, 175, 150, 10 ) ;
  XFlush( XBWin->disp ) ;
}



/* 0-use current, 1-use default, 2-allocate basic*/

int VFPSetMsgColor(info, init_red, init_green, init_blue, size, cmap_flag ) 
     VFPInfo  *info ;
     unsigned char init_red, init_green, init_blue ;
     int           size, cmap_flag ;

{
  XBWindow  *XBWin=info->XBWin ;
  unsigned char *red, *green, *blue ;
  int           i,j,err=0, start ;

  PixVal  temp ;

  start = XBWin->maxcolors ;

  red = (unsigned char*)MALLOC( size * sizeof( unsigned char ) ) ; 
  green = (unsigned char*)MALLOC( size * sizeof( unsigned char ) ) ; 
  blue = (unsigned char*)MALLOC( size * sizeof( unsigned char ) ) ; 

  red[0] = init_red ; 
  green[0] = init_green ; 
  blue[0] = init_blue ; 
  XBSetCmapLight( red, green, blue, size ) ;


  switch( cmap_flag )
    {
    case 0:
    /* printf( " using given colormap \n" ) ; */
      /* try to use given color map */
      if( XBWin->cmap ) {
	if( XBAddCmap( red, green, blue, size, XBWin ) )
	  {
	    printf( "error in adding colors \n" ) ;
	    err = 1 ;
	  }
	/* else
	  printf( " added colors\n" ) ; */
	}
      else
	  {
	    printf( " no given color map\n" ) ; 
	    err = 1 ;
	  }
      break ;

    case 1:
      printf( " using the default colormap \n" ) ;
      /* try to use default color map */
      XBWin->cmap = DefaultColormap( XBWin->disp, XBWin->screen ) ;
      if( XBAddCmap( red, green, blue, size, XBWin ) )
	{
	  printf( "error in adding colors \n" ) ;
	  err = 1 ;
	}
      else
	printf( " added colors\n" ) ;
      break ;

    case 2:
      printf( " allocating basic colormap \n" ) ;
      /* allocate basic colormap */
      XBWin->cmap = (Colormap)0 ;
      XBInitColors( XBWin ) ;
      if( XBAddCmap( red, green, blue, size, XBWin ) )
	{
	  printf( "error in adding colors \n" ) ;
	  err = 1 ;
	}
      else
	printf( " added colors\n" ) ;
      break ;
    }

  /* copy mapping into msg_cmap */

#if 0
  printf( "before loop: size = %d\n, start = %d", size, start ) ;

  for( i=0 ; i<size-1 ; i++ )
    {
      info->msg_cmap[i] = XBWin->cmapping[i+start] ;
      printf( " msg_cmap[%d] = %d\n", i, info->msg_cmap[i] ) ;
    }
#endif

/*


  if( XBCmap( red, green, blue, size, XBWin ) )
    printf( " error in initiating colors\n" ) ;
  else
    printf( " initated colors\n" ) ;
*/

#if 0
  {
    int width ;
    width = (int)500/XBWin->maxcolors;
    for( i=0 ; i<XBWin->maxcolors ; i++ ) 
      {
	/*printf( "%d\n",i) ;*/
      XSetForeground( XBWin->disp, XBWin->gc.set, XBWin->cmapping[i] ) ;
      XFillRectangle( XBWin->disp, XBWin->win, XBWin->gc.set,
          i*width, 0, width, 500 ) ;
      XFlush( XBWin->disp ) ;
      /*for( j=0 ; j<50000 ; j++ ) ;*/
    }
  printf( "done with rectangles\n" ) ;
  }
#endif

  FREE( red ) ;
  FREE( green ) ;
  FREE( blue ) ;

  return( err ) ;
}
