!
!    SCCSid[] = "@(#) ./xtools/solid/mesh3d.c 07/23/93"
!
!
!  MESH.PRC
!
!     (C) Copyright 1989, 1990. Scientific Computing Associates, Inc.
!     All Rights Reserved.
!
!     This software is licensed and not sold.  All use of this software
!     is subject to the terms and conditions of the Scientific Computing
!     Associates, Inc. license, which should be read carefully.  Copyright
!     infringement is a serious civil and criminal offense.

!
! This file contains the routine to convert a mesh into triangles for the
! 3-d triangle renderer.
!
! CLAM procedure mesh_to_tri
!
! Author:    William Gropp
! Date:      01/31/90
! Revisions:
!
!
!
! Given a mesh (x,y) and values on the mesh fz, form the triangles
! representing the mesh.
!   x and y are column vectors
!   fz is a matrix with size(x) rows and size(y) columns;
!   fz(i,j) is the height of the mesh at (x(i),y(j)).
!   (xx,yy,zz,vlist) is a vertex list of the type needed by
!   triangle_fill3d()
!   The color parameter for triangle_fill3d() can be set my
!   "mesh_light_model"
procedure mesh_to_tri( x, y, fz, xx, yy, zz, vlist )
nx  = size(x)(1)
ny  = size(y)(1)
nxny= nx * ny

! Form the vertex arrays
zz  = reshape( [nxny,1], fz )
xx  = reshape( [nxny,1], x * ones(1,ny) )
yy  = reshape( [nxny,1], ones(nx,1) * y' )

! Form the vertex lists.  The "top" of the surface is the outer part.
! vlistb is the first column of the mesh (x varies, uses y(1) and y(2) values)
vlistb  = [ [1:nx-1]', [2:nx]', [1+nx:2*nx-1]' ;
	    [2:nx]', [2+nx:2*nx]', [1+nx:2*nx-1]' ]
vlist   = vlistb
do i=2:ny-1
    vlist   = [ vlist ; (i-1)*nx+vlistb ]
enddo
end
