#ifndef lint
static char SCCSid[] = "@(#) ./xtools/solid/fill3d.c 07/23/93";
#endif

/* #define DEBUG */
#include <stdio.h>
#include "tools.h"
#include "xtools/basex11.h"
#include "xtools/base3d.h"

/* forward definitions */
/*
   Compare two triangles.  
 */
static int sort_tri( a, b )
XBTriangle **a, **b;
{
int  za;
za = (*a)->depth - (*b)->depth;
if (za == 0) return(int)(*a-*b);
return (za > 0) ? 1 : -1;
}
void XB3dDrawTriangles();
void XB3dFillTriangles();

void XB3dSortBackToFront( Obj, q_draw_back )
XBGraphObject *Obj;
int           q_draw_back;
{
XBTriangle    *tri;
XBVertices    *v;
int           nt, nlv, i, dp;
int           x1, y1, a1x, a1y, a2x, a2y, sgn;
XBTxyz        *wxy;

/* Sort the triangles.  We do this by first computing the depth (based on the
   vertex info) and then sorting on depth  We also eliminate from
   consideration all of those triangles that are facing away from the 
   viewer. */
nt  = Obj->nt;
tri = Obj->t;
v   = &Obj->v;
if (!q_draw_back) {
   /* remove those triangles that face away from the viewer */
    nlv= 0;
    for (i=0; i<nt; i++) {
        wxy= XBVertexTXYZ( XBVertexIndex1( tri ), v );
        x1 = XBTX(wxy);
        y1 = XBTY(wxy);
	dp = XBTZ(wxy);
	    
        wxy= XBVertexTXYZ( XBVertexIndex2( tri ), v );
        a1x= XBTX(wxy) - x1;
        a1y= XBTY(wxy) - y1;
	if (XBTZ(wxy) < dp) dp = XBTZ(wxy);

        wxy= XBVertexTXYZ( XBVertexIndex3( tri ), v );
        a2x= XBTX(wxy) - x1;
        a2y= XBTY(wxy) - y1;
	if (XBTZ(wxy) < dp) dp = XBTZ(wxy);

        sgn= a1x * a2y - a1y * a2x;
        if (sgn > 0) {
	    Obj->ts[nlv]    = tri;
	    tri->depth      = dp;
            nlv++;
            }
	tri++;
        }
   }
else {
    for (i=0; i<nt; i++) {
	Obj->ts[i]  = tri;
        wxy= XBVertexTXYZ( XBVertexIndex1( tri ), v );
	dp = XBTZ(wxy);
	    
        wxy= XBVertexTXYZ( XBVertexIndex2( tri ), v );
	if (XBTZ(wxy) < dp) dp = XBTZ(wxy);

        wxy= XBVertexTXYZ( XBVertexIndex3( tri ), v );
	if (XBTZ(wxy) < dp) dp = XBTZ(wxy);
	tri->depth = dp;
	tri++;
        }
    nlv = nt;
    }
Obj->ntvis = nlv;
/* for sorting order: vertices should really be a single structure */
qsort( (char *)Obj->ts, nlv, sizeof(XBTriangle*), (int (*)())sort_tri );
}

/* @
    XBFill3d - Given a graph object, a base X window structure,
               and a transformation structure, draw the figure

    Input Parameters:
    XBWin       - X Base window
    Obj         - object
    Trans       - transformation
    q_draw_back - if true, draw the back side of the triangles

  Constraints:
  We want this to be as fast as possible.  Thus, we expect the triangles
  etc to be packed into arrays so as to make the best use of the data
  cache, and so that operations (such as transforms) can be vectorized.
 @ */
XB3dFill( XBWin, Obj, Trans, q_draw_back )
XBWindow      *XBWin;
XBGraphObject *Obj;
XBTrans3d     *Trans;
int           q_draw_back;
{
/* Apply the transformation to the vertices.  This produces values in the
   display coordinate system (with the z values in a greater range for
   added efficiency in sorting) */
XB3dTranVert( &Obj->v, Trans );

/* Sort the triangles back to front */
XB3dSortBackToFront( Obj, q_draw_back );

/* Now, draw the triangles */
/* Could convert wx and wy to integers now and beat the rush (in a solid, each
   vertex will be in at least 2 if not 3 or more triangles; converting
   to integers first will save extra double->integer conversions.  We
   could even change the triangle structure to contain pointers to vertices
   instead of indices, or even the actual values.  */
XB3dFillTriangles( XBWin, Obj );
}

/* @
    XB3dDraw - Given a graph object, a base X window structure,
               and a transformation structure, draw the frame (edges) of
	       the figure

    Input Parameters:
    XBWin       - X Base window
    Obj         - object
    Trans       - transformation

  Constraints:
  We want this to be as fast as possible.  Thus, we expect the triangles
  etc to be packed into arrays so as to make the best use of the data
  cache, and so that operations (such as transforms) can be vectorized.
 @ */
XB3dDraw( XBWin, Obj, Trans )
XBWindow      *XBWin;
XBGraphObject *Obj;
XBTrans3d     *Trans;
{
int        nt, i;
XBTriangle *tri;

/* Apply the transformation to the vertices.  This produces values in the
   display coordinate system (with the z values in a greater range for
   added efficiency in sorting) */
XB3dTranVert( &Obj->v, Trans );

nt  = Obj->nt;
tri = Obj->t;
for (i=0; i<nt; i++) {
    Obj->ts[i]  = tri + i;
    }
Obj->ntvis = nt;

XB3dDrawTriangles( XBWin, Obj );
}

/*
   Fill the triangles in the order they appear in tri.  Convert the (x,y)
   coords to X coords of triangles
 */
void XB3dFillTriangles( XBWin, Obj )
XBWindow      *XBWin;
XBGraphObject *Obj;
{
XPoint       points[3];
XBTriangle   *tt, **tri;
XBVertices   *v;
int          nt;
XBTxyz       *vx;

nt  = Obj->ntvis;
tri = Obj->ts;
v   = &Obj->v;
while (nt--) {
    tt = *tri++;
    XBSetPixVal( XBWin, tt->discolor );
    vx = XBVertexTXYZ(XBVertexIndex1(tt),v);
    points[0].x = XBTX(vx);
    points[0].y = XBTY(vx);
    vx = XBVertexTXYZ(XBVertexIndex2(tt),v);
    points[1].x = XBTX(vx);
    points[1].y = XBTY(vx);
    vx = XBVertexTXYZ(XBVertexIndex3(tt),v);
    points[2].x = XBTX(vx);
    points[2].y = XBTY(vx);
#ifdef DEBUG
    printf( "(%d,%d)x(%d,%d)x(%d,%d)\n", points[0].x, points[0].y,
            points[1].x, points[1].y, points[2].x, points[2].y );
#endif
    XFillPolygon( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set,
                      points, 3, Convex, CoordModeOrigin );
    }
}

/*
   Draw the triangles in the order they appear in tri.  Convert the (x,y)
   coords to X coords of triangles
 */
void XB3dDrawTriangles( XBWin, Obj )
XBWindow      *XBWin;
XBGraphObject *Obj;
{
XPoint       points[4];
XBTriangle   *tt, **tri;
XBVertices   *v;
int          nt;
XBTxyz       *vx;

nt  = Obj->ntvis;
tri = Obj->ts;
v   = &Obj->v;
while (nt--) {
    tt = *tri++;
    XBSetPixVal( XBWin, tt->discolor );
    vx = XBVertexTXYZ(XBVertexIndex1(tt),v);
    points[0].x = XBTX(vx);
    points[0].y = XBTY(vx);
    vx = XBVertexTXYZ(XBVertexIndex2(tt),v);
    points[1].x = XBTX(vx);
    points[1].y = XBTY(vx);
    vx = XBVertexTXYZ(XBVertexIndex3(tt),v);
    points[2].x = XBTX(vx);
    points[2].y = XBTY(vx);
    points[3]   = points[0];
#ifdef DEBUG
    printf( "(%d,%d)x(%d,%d)x(%d,%d)\n", points[0].x, points[0].y,
            points[1].x, points[1].y, points[2].x, points[2].y );
#endif
    XDrawLines( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set,
                      points, 4, CoordModeOrigin );
    }
}

/* @

   Define the vertices for a object
@ */
void XB3dAddVerticesFromXYZ( obj, n, x, y, z )
XBGraphObject *obj;
int           n;
double        *x, *y, *z;
{
int i;
XBVertices *v;
XBxyz      *xyz;

v     = &obj->v;
xyz   = v->xyz + v->nv;
for (i=0; i<n; i++) {
    XBVX(xyz) = *x++;
    XBVY(xyz) = *y++;
    XBVZ(xyz) = *z++;
    xyz++;
    }
v->nv += n;
}

/* @

   Define the vertices for a object
@ */
void XB3dDefineVerticesFromXYZ( obj, n, x, y, z )
XBGraphObject *obj;
int           n;
double        *x, *y, *z;
{
XBVertices *v;

v     = &obj->v;
v->nv = 0;
XB3dAddVerticesFromXYZ( obj, n, x, y, z );
}

void XB3dDefineTriangles( obj, n, tris )
XBGraphObject *obj;
int           n;
XBTriangle    *tris;
{
int i;
XBTriangle *t;

t       = obj->t;
obj->nt = n;
for (i=0; i<n; i++) {
    *t++ = *tris++;
    }
}

/*
   Dumpt the triangles to the given file.
 */
void XB3dDumpTriangles( XBWin, Obj, fp )
XBWindow      *XBWin;
XBGraphObject *Obj;
FILE          *fp;
{
XPoint       points[4];
XBTriangle   *tt, **tri;
XBVertices   *v;
int          nt;
XBTxyz       *vx;

nt  = Obj->ntvis;
tri = Obj->ts;
v   = &Obj->v;
while (nt--) {
    tt = *tri++;
    XBSetPixVal( XBWin, tt->discolor );
    vx = XBVertexTXYZ(XBVertexIndex1(tt),v);
    points[0].x = XBTX(vx);
    points[0].y = XBTY(vx);
    vx = XBVertexTXYZ(XBVertexIndex2(tt),v);
    points[1].x = XBTX(vx);
    points[1].y = XBTY(vx);
    vx = XBVertexTXYZ(XBVertexIndex3(tt),v);
    points[2].x = XBTX(vx);
    points[2].y = XBTY(vx);
    points[3]   = points[0];
    fprintf( fp, "(%d,%d)x(%d,%d)x(%d,%d)\n", points[0].x, points[0].y,
                 points[1].x, points[1].y, points[2].x, points[2].y );
    }
}

/* @
    XB3dDump - Given a graph object, a base X window structure,
               and a transformation structure, dump the frame (edges) of
	       the figure

    Input Parameters:
    XBWin       - X Base window
    Obj         - object
    Trans       - transformation
    fp          - file to dump to

  Constraints:
  We want this to be as fast as possible.  Thus, we expect the triangles
  etc to be packed into arrays so as to make the best use of the data
  cache, and so that operations (such as transforms) can be vectorized.
 @ */
XB3dDump( XBWin, Obj, Trans, fp )
XBWindow      *XBWin;
XBGraphObject *Obj;
XBTrans3d     *Trans;
FILE          *fp;
{
int        nt, i;
XBTriangle *tri;

/* Apply the transformation to the vertices.  This produces values in the
   display coordinate system (with the z values in a greater range for
   added efficiency in sorting) */
XB3dTranVert( &Obj->v, Trans );

nt  = Obj->nt;
tri = Obj->t;
for (i=0; i<nt; i++) {
    Obj->ts[i]  = tri + i;
    }
Obj->ntvis = nt;

XB3dDumpTriangles( XBWin, Obj, fp );
}

