#ifndef lint
static char SCCSid[] = "@(#) ./xtools/quick/qxbase.c 07/23/93";
#endif

#include "tools.h"
#include "xtools/basex11.h"

/*
   This file contains a crude interface to the xtools codes.
   It provides a way to provide a single window that various tools may
   use to draw in.
 */

/*
   Note that these globals should really be in a single place so that
   XBQ and XBPQ don't need separate areas
 */
static XBWindow *XBQWin = 0;
static Window   OutsideWinId = 0;
static int px = -1, py = -1, pw = 400, ph = 400;
static int Ncolors = 0;

/*@
   XBQGetArgs - Process argument list for XB options

   Input Parameters:
.  Argc - pointer to argument count
.  argv - argument vectors
.  flag - if true, remove arguments that are found

   Arguments recognized:
$  -winid nn         X11 Window ID to use (window must ALREADY exist)
$  -geometry WxH+X+Y X11 geometry specification
$  -bw               Use black and white (on color displays)
@*/
void XBQGetArgs( Argc, argv, flag )
int  *Argc, flag;
char **argv;
{
SYArgGetInt( Argc, argv, flag, "-winid", (int *)&OutsideWinId );
if (SYArgHasName( Argc, argv, flag, "-bw" )) Ncolors = 2;
XBGetArgs( Argc, argv, flag, &px, &py, &pw, &ph );
}

XBWindow *XBQGetWindow( name, disp )
char *name, *disp;
{
int err;
if (!XBQWin) {
    XBQWin = XBWinCreate();    CHKPTRN(XBQWin);
    if (OutsideWinId) 
	err = XBQuickWindowFromWindow( XBQWin, disp, OutsideWinId );
    else
	err = XBiQuickWindow( XBQWin, disp, name, px, py, pw, ph, Ncolors );
    if (err) {
	XBWinDestroy( XBQWin );
	XBQWin = 0;
	return 0;
	}
    }
return XBQWin;
}

/*@
    XBQStartDisplay - Start a Quick window

    Input Parameters:
.   name - title (name) of window
.   disp - name of display
.   x,y  - location of the upper left corner of the window
.   w.h  - width and height of the window

    Note:
    This routine is not needed for the Quick routines; if no window
    has been started when they are called, they will start one.
    This routine allows you to start the window with other than the
    default parameters, such as a different size, location, or server.
@*/
void XBQStartDisplay( name, disp, x, y, w, h )
char *name, *disp;
int  x, y, w, h;
{
px = x;
py = y;
pw = w;
ph = h;
(void)XBQGetWindow( name, disp );
}

/*@
     XBQExchangeQuickWindow - Change the window used by XBQ (quick) routines

   Input Parameter:
.  win - Window to replace the "Quick" window with.

   Notes:   
   Given a window replaces the "Quick" Window with 
   the given window and returns the given window. In this way one may 
   use this to force the XBQContour(), XBQMatrix(), XBQSurface() to use 
   a window of the users choose instead of the "quick" window.
@*/
XBWindow *XBQExchangeQuickWindow( win )
XBWindow *win;
{
XBWindow *tmp;

tmp    = XBQWin;
XBQWin = win;
return tmp;
}
