#ifndef lint
static char SCCSid[] = "@(#) ./xtools/papps/qpopen.c 07/23/93";
#endif

/* 
    This file contains routines that provide a single window to a parallel
    process.  This is done by having one process open the window, and
    having the other processes access that window.

    An extension to this allows multiple parallel windows, accessed by 
    a stack (note that multiple windows may be open simultaneously;
    these are used only when creating a window).
 */

#include <stdio.h>
#include "tools.h"
#include "comm/comm.h"           /*I "comm/comm.h" I*/
#include "xtools/basex11.h"

#define MAX_WINS   10
static int actWins = 0;
static XBWindow *(XBPQWin[MAX_WINS]);
static char LocalHost[1024];

static int px = -1, py = -1, pw = 400, ph = 400;

/* This routine processes args for the quick entry versions.  For now,
   it looks for -winid nn 
 */
void XBPQGetArgs( Argc, argv, flag )
int  *Argc, flag;
char **argv;
{
XBGetArgs( Argc, argv, flag, &px, &py, &pw, &ph );
}

/*@
  XBPSetLocalHost - set the name of the local host to display on
  
  Input Parameter:
. hostname - name of the local host.  Must be in valid X11 -display format  
@*/
void XBPSetLocalHost( hostname )
char *hostname;
{
strcpy( LocalHost, hostname );
}

/*@
   XBPQuickWindow - Open a basic X11 window for use by a group of processes

   Input Parameters:
.  mywindow - XBWindow structure
.  src - processor id of the processor to "own" the window.
.  hostname - name of the display, in standard X 11 format
.  name - name of the window
.  x,y  - location of window
.  w,h  - width and height of the window
.  procset - processor subset to use
@*/
void XBPQuickWindow( mywindow, src, hostname, name, x, y, w, h, procset )
XBWindow *mywindow;
char    *hostname, *name;
int     src, x, y, w, h;
ProcSet *procset;
{
Window win;

if (src == PImytid) {
    XBQuickWindow( mywindow, hostname, name, x, y, w, h );
#ifdef FOO
    if (hostname[0] == 0) {
	hostname =getenv( "DISPLAY" );
	/* Must convert :0.0 to hostname:0  */
	}
#endif
    /* ALWAYS send the local host */
    if (!LocalHost[0]) {
	SYGetHostName( LocalHost, 1024 );
	strcat( LocalHost, ":0" );
	}
    GSCATTER( LocalHost, 1024, 1, procset, MSG_OTHER );
    win = mywindow->win;
    GSCATTER( &win, sizeof(Window), 1, procset, MSG_INT );
    }
else {
    GSCATTER( LocalHost, 1024, 0, procset, MSG_OTHER );
    if (hostname[0] == '\0') {
	hostname = LocalHost;
	}
    GSCATTER( &win, sizeof(Window), 0, procset, MSG_INT );
    XBQuickWindowFromWindow( mywindow, hostname, win );
    if (!mywindow->win) {
	char myname[1024];
	SYGetHostName( myname, 1024 );
	fprintf( stderr, "Failed to connect from %s to %s\n", 
		 myname, hostname );
	}	 
    }
}

/*@
  XBPQGetWindow - return the window generated with XBPQuickWindow.

  Input Parameters:
. name - name for the window
. disp - name of the display

  Notes:
  If no window has been created, one will be generated using default
  parameters and all processors.

  If you want routines that use XBPQGetWindow to use a different window
  or label, use ??? to set the parameters.

  Use XBPQuickDestroy to remove the window (not yet implemented).

  If no window can be created, a null pointer is returned instead.
@*/
XBWindow *XBPQGetWindow( name, disp )
char *name, *disp;
{
if (actWins == 0) {
    XBPQWin[0] = NEW(XBWindow);
    XBPQuickWindow( XBPQWin[0], 0, disp, name, px, py, pw, ph, ALLPROCS );
    if (!XBPQWin[0]->disp) {
	FREE( XBPQWin[0] );
	return 0;
	}
    actWins++;
    }
return XBPQWin[actWins-1];
}

/* @
     XBPQPushWindow - push a parallel window for the quick routines to use

     Input Parameters:
.    name - name for the window
.    disp - name of the display
.    x,y  - location of window
.    w,h  - width and height of the window
@ */
void XBPQPushWindow( name, disp, x, y, w, h )
char *name, *disp;
int  x, y, w, h;
{
if (actWins < MAX_WINS) {
    XBPQWin[actWins] = NEW(XBWindow);     CHKPTR(XBPQWin[actWins]);
    XBPQuickWindow( XBPQWin[actWins], 0, disp, name, x, y, w, h, ALLPROCS );
    actWins++;
    }
}

/* @
     XBPQPopWindow - pop a window
@ */
void XBPQPopWindow()
{
if (actWins > 0) {
    /* Should we CLOSE the window ? */
    actWins--;
    }
}

/*
   We also need a routine to close a parallel window in a clean way.
 */

/* Stub for later */
void XBPQuickDestroy()
{
}


