#ifndef lint
static char SCCSid[] = "@(#) ./xtools/contour/cntrquad.c 07/23/93";
#endif
/*
    This file creates a contour map for a mesh defined by quadrilaterals.
 */

#include <stdio.h>
#include "tools.h"
#include "xtools/basex11.h"

#define SHIFT_VAL 6
extern void XBSetmap();

/* map needs to be nx * ny * sizeof(char) for 8-bit colors */

/*@
    XBContourQuadrilaterals - Draw a contour plot on the display of data 
    defined on a quadrilateral mesh

    Input parameters:
.    matrix - array of data (mx x my)
.    x,y    - x/y values of coordinate lines of matrix.  Each is of size
     mx x my
.    imap   - color mapping
.    nc     - number of colors
.    map    - bitmap used to hold image (size nx x ny)
.    nx,ny  - size of contour plot in pixels
.    xoff,yoff - location in window of upper left corner (often 0,0)
.    coff      - min colormap INDEX.
@*/
void XBContourQuadrilaterals( XBWin, matrix, mx, my, x, y, imap, nc, map, 
                              nx, ny, xoff, yoff, coff )
XBWindow        *XBWin;
int             mx, my, nx, ny, nc, xoff, yoff, coff;
double          *matrix, *x, *y;
double          *imap;
unsigned char   *map;
{
int             i, j, ij;
double          *p;
unsigned char   *mp;
int             ul, ur, ll, lr, nnx, nny;
int             *ix, *iy;
int             cshift = (coff << SHIFT_VAL);
extern int *XBGetlocUnsorted();

/* determine the sizes of the cells based on x, y */
ix  = XBGetlocUnsorted( nx, mx*my, x );
iy  = XBGetlocUnsorted( ny, mx*my, y );
if (!ix || !iy) {
    if (!ix) SETERRC(1,"x indices invalid");
    if (!iy) SETERRC(1,"y indices invalid");
    return;
    }
/* printf( ">>>>>Starting setmap\n" ); */
ij = 0;
for (j=0; j<my-1; j++) {
    p   = matrix + j * mx;
    if (iy[j] >= ny || iy[j] < 0) {
	fprintf( stderr,
		"in setmap, offsets to map (iy[%d]=%d) exceed (ny=%d)\n",
		j, iy[j], ny );
	continue;
	}
    ur  = XBGetimap( imap, nc, *p ) + cshift;
    lr  = XBGetimap( imap, nc, *(p + mx) ) + cshift;
    for (i=0; i<mx-1; i++) {
        if (ix[i] >= nx || ix[i] < 0) {
            fprintf( stderr,
                     "in setmap, offsets to map (ix[%d]=%d) exceed (nx=%d)\n",
                        i, ix[i], nx );
	    continue;
            }
        nnx = ix[i+1] - ix[i] + 1;
        nny = iy[j+1] - iy[j] + 1;
	p++;
        ul  = ur;
        ur  = XBGetimap( imap, nc, *(p) ) + cshift;
        ll  = lr;
        lr  = XBGetimap( imap, nc, *(p + mx) ) + cshift;
/*
        printf( 
    "setting triangle vertices ul(%d,%d), ur(%d,%d), ll(%d,%d), lr(%d,%d)\n", 
                ix[ij+mx], iy[ij+mx], ix[ij+1+mx], iy[ij+1+mx], 
	        ix[ij], iy[ij], ix[ij+1], iy[ij+1] );
        printf( "corner colors <ulur x lllr> (%d,%d) x (%d,%d)\n", 
	        ul, ur, ll, lr );
 */
        XBSetTriangle( map, nx, ix[ij+mx], iy[ij+mx], ll, 
		                ix[ij+1+mx], iy[ij+1+mx], lr, 
		                ix[ij], iy[ij], ul, nc, coff );
        XBSetTriangle( map, nx, ix[ij], iy[ij], ul, 
		                ix[ij+1+mx], iy[ij+1+mx], lr, 
		                ix[ij+1], iy[ij+1], ur, nc, coff );
/*
        printf( "after setTriangle\n" );
        printmap( map, nx, ny );
 */
	ij++;
        }
    ij++;  /* Since we don't go to the end of the line, just the last cell */
    }

FREE( ix );
FREE( iy );

/* Draw the image */
XBContourDrawWithSetMap( XBWin, map, xoff, yoff, nx, ny );
}

/*@
    XBContourDrawQuadrilaterals - Draw the quadrialterals used to produce 
    a contour plot.

    Input parameters:
.    x,y    - x/y values of coordinate lines of matrix.  Each is of size
     mx x my
.    color  - color to use
.    nx,ny  - size of contour plot in pixels
.    xoff,yoff - location in window of upper left corner (often 0,0)
@*/
void XBContourDrawQuadrilaterals( XBWin, mx, my, x, y, color, 
				  nx, ny, xoff, yoff )
XBWindow        *XBWin;
int             mx, my, nx, ny, xoff, yoff;
double          *x, *y;
PixVal          color;
{
int             i, j, ij;
int             *ix, *iy;
extern int *XBGetlocUnsorted();

/* determine the sizes of the cells based on x, y */
ix  = XBGetlocUnsorted( nx, mx*my, x );
iy  = XBGetlocUnsorted( ny, mx*my, y );
XBSetPixVal( XBWin, color );
if (!ix || !iy) {
    if (!ix) SETERRC(1,"x indices invalid");
    if (!iy) SETERRC(1,"y indices invalid");
    return;
    }
ij = 0;
for (j=0; j<my-1; j++) {
    for (i=0; i<mx-1; i++) {
	XDrawLine( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set, 
		   ix[ij], iy[ij], ix[ij+1], iy[ij+1] );
	XDrawLine( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set, 
		   ix[ij], iy[ij], ix[ij+mx], iy[ij+mx] );
	ij++;
        }
    XDrawLine( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set, 
	       ix[ij], iy[ij], ix[ij+mx], iy[ij+mx] );
    ij++;  /* Since we don't go to the end of the line, just the last cell */
    }
/* Draw the "top" line */
for (i=0; i<mx-1; i++) {
    XDrawLine( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set, 
	       ix[ij], iy[ij], ix[ij+1], iy[ij+1] );
    ij++;
    }
XBFlush( XBWin );
FREE( ix );
FREE( iy );
}

