/*
   This file contains definitions for a simple "state" tracking
   facility
 */
/*I "system/state.h" I*/
#ifndef __STATE
#define __STATE

#include "system/time/usec.h"

typedef struct {
    double     time;
    int        count;
    int        data;
    void       (*routine)();
    void       *rcontext;
    } SYstate;

extern void SYStatePush(), SYStatePop(), SYStateInit();
/* Use SYNullState to initialize a state to NULL */
#define SYNullState {0,0,0,0,0}

/*M
    SYStateSetRoutine - Set the routine to be called on each state change

    Synopsis:
    void SYStateSetRoutine( state, r, ctx )
    SYstate *state;
    void    (*r)(), *ctx;

    Input Parameters:
.   state - state to set routine for
.   r     - routine.  Must be of the form
$           void r(state,flag)
$           SYState *state;
$           int     flag;
$           state is the state that is calling the routine; flag is 0 for
$           a POP and 1 for a PUSH.
.   ctx   - a context variable for the use of r.  It is available as
            state->rcontext.
M*/
#define SYStateSetRoutine(state,r,ctx) \
      {(state)->routine=r;(state)->rcontext = ctx;}

#endif
