/*

   This routine belongs in the tools/sparse directory!!

*/

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"

/*@
   SpSplitFromMat - Given a sparse matrix, creates a SpMatSplit by 
   determining the location of the diagonal for each row.
   IMPORTANT: Does NOT copy the matrix data 
 
   Input Parameters:
   mat - matrix to split

   Returns:
   A split matrix 
 @*/
SpMatSplit *SpSplitFromMat(mat)
SpMat *mat;
{
  SpMatSplit *split;
  int        i,n = mat->rows,nz, *xi, j ;
  SpRowMat   *R;
  SpVec      **rs, *row;

  split         = NEW(SpMatSplit);  CHKPTRV(split,0);
  split->type   = MATSPLIT;
  split->factor = mat;
  split->nzl    = (int *) SPMalloc(n*sizeof(int)); CHKPTRV(split->nzl,0);

  R      = GETROWMAT(mat);
  rs     = R->rs;
  for ( i=0; i<n; i++ ) {
    row  = *rs++;
    xi   = row->i;
    nz   = row->nz;
    for ( j=0; j<nz; j++ ) {
      if ( *xi++ >= i ) {
        split->nzl[i] = j;
        break;
      }
    }
  }
  return split;
}
