/*
  forward-backsolve on a SpMatSplit derived from a Cholesky factorization.
*/
#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"
#include "inline/spops.h"
/*
   SpiSolveSymmetric - Performs a forwardsolve/backsolve assuming the
  SpMatSplit came from a Choleski factorization. The difference 
  between this solve and the standard solve is that the diagonal 
  part is used in both the forward solve and the backsolve.
 */
int SpiSolveSymmetric( BB, x, b )
SpMatSplit  *BB;
double      *x, *b;
{
int          i, n, *nzs;
double   *vv;
register double       *v, sum;
register int          *vi, nz;
SpMat    *B = BB->factor;
SpVec    *row, **rs;
SpRowMat *R = (SpRowMat *)B->data;

n      = B->rows;
/* forward solve the lower triangular */
nzs    = BB->nzl + 1;
rs     = R->rs;
row    = *rs++;
x[0]   = (*b++)*(row->v[0]);
for (i=1; i<n; i++) {
    row  = *rs++;
    v    = row->v;
    vi   = row->i;
    nz   = *nzs;
    sum  = *b++;
    SPARSEDENSEMDOT(sum,x,v,vi,nz);
    x[i] = sum* (row->v[*nzs++]);
    }

/* backward solve the upper triangular */
nzs--; rs--;
for (i=n-1; i>=0; i--) {
    nz   = *nzs-- + 1;
    row  = *rs--;
    vv = v = row->v + nz;
    vi   = row->i + nz;
    nz   = row->nz - nz;
    sum  = x[i];
    SPARSEDENSEMDOT(sum,x,v,vi,nz);
    x[i] = sum * *(vv-1);
    }
return 0;
}
