/* @(#) ./sparse/sppriv.h 07/23/93 */

/* Private structures for the sparse matrix routines.  Absolutely
   everything here is subject to change. */

/* I should change the "double" to an appropriate typedef so that block and
   complex routines could be accommodated */

/* Here is a simple sparse row that is used in the row-oriented
   sparse matrix structure */   
typedef struct {
    int    nz,      /* number of non-zeros */
           maxn,    /* allocated size */
           blki,    /* index of the row elim block that contains this row.
                       -1 if none */
           rblki,   /* index of the row block that contains this row, -1 if
		       none */
           dloc,    /* location of diagonal */
           *i;      /* column indices */
    double *v; 
    } SpVec;

/* A block is defined as a group of rows that have identical structure 
   starting from either the first element or the diagonal element of the
   first row in the block */
typedef struct {
    int nblocks,                  /* Number of blocks */
        *startrows, *blocksize;   /* Index of starting row and number of
				     rows in that block */
    int **offsets;                /* Offset to first common element */
    } SpRowBlock;

/* Row-oriented structure with optional hierarchy */
typedef struct {
    SpVec      **rs;
    SpRowBlock *blks;     /* Elimination blocks (start at the diagonal) */
    SpRowBlock *rblks;    /* Row blocks (start at first non-zero column) */
    } SpRowMat;

/* AIJ structure; allows easy interface with SPARSEPAK routines.  In addition
   to the usual elements, a "dloc" array, of size nrows, contains the
   locations of the diagonal entries */
typedef struct {
    int    *ia, *ja, *dloc;
    double *a;
    int    quser;                /* 1 if user allocated ia etc, 0 otherwise */
    int    maxnz, maxrow;        /* max sizes for allocations */
    } SpAIJ;

/* Here are the known matrix types.  They are:
   row   - row oriented storage
   split - (obsolete) MATROW with additional information about the location
           of the diagonal (used for matrix splitings split along a diagonal)
   aij   - stored in conventional aij format (suitable for Fortran routines)
   block - like row, but each element is a block (in fact, each is a pointer
           so the contents of the block can be arbitray.  This may be more
           general than we eventually want.
   rowdist- matrix distributed by rows across multiple processors
   dense  - matrix is actually stored as DENSE; this allows use to switch
            between dense and sparse problems
 */           
#define MATROW     1
#define MATSPLIT   2
#define MATAIJ     3
#define MATBLOCK   4
#define MATROWDIST 5
#define MATDIAG    6
#define MATDENSE   7

extern int *SpiDupMapping();

#define SPMalloc(a) MALLOC(a)
#define SPFree(a)   FREE(a)
/* Temps (space used only in a routine and returned before/on exit */
#define SPAllocTemp(a) MALLOC(a)
#define SPFreeTemp(a)  FREE(a)
/* These routine allocate and free the storage for the values in a sparse
   vector */
#define SPAllocV(a,v,i) {v = (double *)SPMalloc((a)*(sizeof(double)+\
sizeof(int)));i=(int *)(v+a);}
#define SPFreeV(a) SPFree(a->v)
#define SPFreeVv(a) SPFree(a)

/* Sparse Matrix */
/* Inline the allocation routine for additional efficiency */
#ifdef USE_NOCHUNCK
#define SPiPoolAllocNVt(Pool,nzf,v,i,err) {SPAllocV(nzf,*v,*i);err=0;}
#else
/* we have to correctly handle the case of sizeof(double) != 2 * sizeof(int)
   In particular, we need to compute the number of bytes preserving alignment
   of doubles */
#if defined(cray)
/* sizeof(double) == sizeof(int) */
#define SPI_NDOUBLES(n) (n+n)
#define SPI_NELMS(n)    (n)
#else
/* sizeof(double) == 2 * sizeof(int) */
#define SPI_NDOUBLES(n) (n+((n+1)>>1))
#define SPI_NELMS(n)    (n+((n)&0x1))
#endif
#define SPiPoolAllocNVt(Pool,nzf,v,i,err) if ((nzf) <= (Pool)->pool.n) {\
*(v) = (Pool)->pool.ptr;*(i) = (int *)(*(v) + nzf);\
(Pool)->pool.ptr+=SPI_NDOUBLES(nzf);(Pool)->pool.n-=SPI_NELMS(nzf);\
(Pool)->alloc->nalloc++;err=ERR_NONE;}\
else SPiPoolAllocNV(Pool,nzf,v,i);
#endif
#define SPiMallocNVt(mat,nzf,v,i,err) SPiPoolAllocNVt(&((mat)->pool),nzf,v,i,err)

/* Convert mat from SPLIT to regular */
#define SPLITTOMAT(a) {if ((a)->type==MATSPLIT)a=((SpMatSplit *)(a))->factor;}

/* Get the rowmat structure from a mat */
#define GETROWMAT(a) ((SpRowMat *)((a)->data))

extern void *SpiBlockMalloc();
extern void SpiBlockFree(), SpiBlockFreeAll();

