#ifndef lint
static char SCCSid[] = "@(#) ./sparse/order/sporder.c 07/23/93";
#endif


#include "tools.h"
#include "sparse/spmat.h"
#include "system/nreg.h"

/* -------------------------------------------------------------*/
static NRList *__OrderList = 0;
/* -------------------------------------------------------------*/
/*@
   SpOrderRegister - Given a matrix ordering routine and an integer, 
  registers that ordering routine, so that a user can call SpOrder()
  with that integer and have the correct ordering routine called.
 
   Input Parameters:
.      name  - for instance ORDER_RCM, 
.      sname -  corresponding string for name
.      order - routing to perform that ordering
@*/
void SpOrderRegister(name, sname, order)
SPORDERTYPE name;
char        *sname;
void (*order)();
{
if (!__OrderList) __OrderList = NRCreate();
NRRegister( __OrderList, name, sname, order );
}

/*----------------------------------------------------------------*/
/*@
   SpOrderRegisterDestroy - Frees the list of ordering routines
  that have been registered.
@*/
void SpOrderRegisterDestroy()
{
if (__OrderList) {
    NRDestroy( __OrderList );
    __OrderList = 0;
    }
}
/* -------------------------------------------------------------*/
/*@
    SpOrder - Finds an ordering for a matrix.

    Input Parameters:
.    Matrix   - matrix to order
.    ordering - ordering to chose

    Output Parameters:
.    perm     - permutation matrix
.    iperm    - inverse permutation matrix (may be NULL)
@*/
void SpOrder( Matrix, ordering, perm, iperm )
SpMat       *Matrix;
SPORDERTYPE ordering;
int         *perm, *iperm;
{
void  (*r)();

/* Get the function pointers for the ordering method requested */
if (!__OrderList) {SpOrderRegisterAll();}
if (!__OrderList) {SETERRC(1,"Could not acquire list of orderings"); return;}
r =  NRFindRoutine( __OrderList, ordering, (char *)0 );
if (!r) {SETERRC(1,"Could not find requested ordering"); return;}

(*r)(Matrix, perm, iperm );
}
/* -------------------------------------------------------------*/
static char *(SpONAME[6]) = { "RCM", "QMD", "ND", "1WD", "RQT", "Invalid" };
char *SpOrderName( ordering )
int ordering;
{
int i;
i = ordering;
if (i < 0 || i > 4) i = 5;
return SpONAME[i];
}

/*@
  SpGetOrdering - Return the selected ordering, given the argument list.

  Input parameters:
. Argc - pointer to arg count
. argv - argument vector
. sname - name used to indicate ordering.  If null, -ordering is used

  Output parameter:
. ordering -  Matrix reordering type
@*/
void SpGetOrdering( Argc, argv, sname, ordering )
int         *Argc;
char        *argv, *sname;
SPORDERTYPE *ordering;
{
char sbuf[50];

if (!sname) sname = "-ordering";
if (SYArgGetString( Argc, argv, 1, sname, sbuf, 50 )) {
    if (!__OrderList)
	SpOrderRegisterAll();
    *ordering = (SPORDERTYPE) NRFindID( __OrderList, sbuf );
    }
}

