#ifndef lint
static char SCCSid[] = "@(#) ./sparse/order/spnd.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"

#if defined(FORTRANCAPS)
#define gennd_ GENND
#elif !defined(FORTRANUNDERSCORE)
#define gennd_ gennd
#endif 

/*@
    SpOrderND - Find the nested dissection ordering of a given matrix.

    Input Paramter:
.    Matrix - matrix to find ordering for

    Output Parameters:
.    perm   - permutation vector (0-origin)
.    iperm  - inverse permutation vector.  If NULL, ignored.
@*/    
void SpOrderND( Matrix, perm, iperm )
SpMat *Matrix;
int   *perm, *iperm;
{
int i, nrow, *ia, *ja, *mask, *xls, *ls;

nrow= Matrix->rows;
SpToSymmetricIJ( Matrix, &ia, &ja ); CHKERR(0);

mask = (int *)MALLOC( nrow * sizeof(int) ); CHKPTR(mask);
xls  = (int *)MALLOC( (nrow + 1) * sizeof(int) ); CHKPTR(xls);
ls   = (int *)MALLOC( nrow * sizeof(int) ); CHKPTR(ls);

gennd_( &nrow, ia, ja, mask, perm, xls, ls );
FREE( ia );  FREE( ja );
FREE( mask ); FREE( xls ); FREE( ls );

for (i=0; i<nrow; i++) perm[i]--;
if (iperm) SpInverse( nrow, perm, iperm );
}


