C----- SUBROUTINE GENQMD
C****************************************************************          1.
C****************************************************************          2.
C**********    GENQMD ..... QUOT MIN DEGREE ORDERING    *********          3.
C****************************************************************          4.
C****************************************************************          5.
C                                                                          6.
C     PURPOSE - THIS ROUTINE IMPLEMENTS THE MINIMUM DEGREE                 7.
C        ALGORITHM.  IT MAKES USE OF THE IMPLICIT REPRESENT-               8.
C        ATION OF THE ELIMINATION GRAPHS BY QUOTIENT GRAPHS,               9.
C        AND THE NOTION OF INDISTINGUISHABLE NODES.                       10.
C        CAUTION - THE ADJACENCY VECTOR ADJNCY WILL BE                    11.
C        DESTROYED.                                                       12.
C                                                                         13.
C     INPUT PARAMETERS -                                                  14.
C        NEQNS - NUMBER OF EQUATIONS.                                     15.
C        (XADJ, ADJNCY) - THE ADJACENCY STRUCTURE.                        16.
C                                                                         17.
C     OUTPUT PARAMETERS -                                                 18.
C        PERM - THE MINIMUM DEGREE ORDERING.                              19.
C        INVP - THE INVERSE OF PERM.                                      20.
C                                                                         21.
C     WORKING PARAMETERS -                                                22.
C        DEG - THE DEGREE VECTOR. DEG(I) IS NEGATIVE MEANS                23.
C               NODE I HAS BEEN NUMBERED.                                 24.
C        MARKER - A MARKER VECTOR, WHERE MARKER(I) IS                     25.
C               NEGATIVE MEANS NODE I HAS BEEN MERGED WITH                26.
C               ANOTHER NODE AND THUS CAN BE IGNORED.                     27.
C        RCHSET - VECTOR USED FOR THE REACHABLE SET.                      28.
C        NBRHD - VECTOR USED FOR THE NEIGHBORHOOD SET.                    29.
C        QSIZE - VECTOR USED TO STORE THE SIZE OF                         30.
C               INDISTINGUISHABLE SUPERNODES.                             31.
C        QLINK - VECTOR TO STORE INDISTINGUISHABLE NODES,                 32.
C               I, QLINK(I), QLINK(QLINK(I)) ... ARE THE                  33.
C               MEMBERS OF THE SUPERNODE REPRESENTED BY I.                34.
C                                                                         35.
C     PROGRAM SUBROUTINES -                                               36.
C        QMDRCH, QMDQT, QMDUPD.                                           37.
C                                                                         38.
C****************************************************************         39.
C                                                                         40.
C                                                                         41.
      SUBROUTINE  GENQMD ( NEQNS, XADJ, ADJNCY, PERM, INVP, DEG,          42.
     1                     MARKER, RCHSET, NBRHD, QSIZE, QLINK,           43.
     1                     NOFSUB )                                       44.
C                                                                         45.
C****************************************************************         46.
C                                                                         47.
         INTEGER ADJNCY(1), PERM(1), INVP(1), DEG(1), MARKER(1),          48.
     1           RCHSET(1), NBRHD(1), QSIZE(1), QLINK(1)                  49.
         INTEGER XADJ(1), INODE, IP, IRCH, J, MINDEG, NDEG,               50.
     1           NEQNS, NHDSZE, NODE, NOFSUB, NP, NUM, NUMP1,             51.
     1           NXNODE, RCHSZE, SEARCH, THRESH                           52.
C                                                                         53.
C****************************************************************         54.
C                                                                         55.
C        -----------------------------------------------------            56.
C        INITIALIZE DEGREE VECTOR AND OTHER WORKING VARIABLES.            57.
C        -----------------------------------------------------            58.
         MINDEG = NEQNS                                                   59.
         NOFSUB = 0                                                       60.
         DO 100 NODE = 1, NEQNS                                           61.
            PERM(NODE) = NODE                                             62.
            INVP(NODE) = NODE                                             63.
            MARKER(NODE) = 0                                              64.
            QSIZE(NODE)  = 1                                              65.
            QLINK(NODE)  = 0                                              66.
            NDEG = XADJ(NODE+1) - XADJ(NODE)                              67.
            DEG(NODE) = NDEG                                              68.
            IF ( NDEG .LT. MINDEG )  MINDEG = NDEG                        69.
  100    CONTINUE                                                         70.
         NUM = 0                                                          71.
C        -----------------------------------------------------            72.
C        PERFORM THRESHOLD SEARCH TO GET A NODE OF MIN DEGREE.            73.
C        VARIABLE SEARCH POINTS TO WHERE SEARCH SHOULD START.             74.
C        -----------------------------------------------------            75.
  200    SEARCH = 1                                                       76.
            THRESH = MINDEG                                               77.
            MINDEG = NEQNS                                                78.
  300       NUMP1 = NUM + 1                                               79.
               IF ( NUMP1 .GT. SEARCH )  SEARCH = NUMP1                   80.
               DO 400 J = SEARCH, NEQNS                                   81.
                  NODE = PERM(J)                                          82.
                  IF ( MARKER(NODE) .LT. 0 )  GOTO 400                    83.
                     NDEG = DEG(NODE)                                     84.
                     IF ( NDEG .LE. THRESH )  GO TO 500                   85.
                     IF ( NDEG .LT. MINDEG )  MINDEG =  NDEG              86.
  400          CONTINUE                                                   87.
            GO TO 200                                                     88.
C           ---------------------------------------------------           89.
C           NODE HAS MINIMUM DEGREE. FIND ITS REACHABLE SETS BY           90.
C           CALLING QMDRCH.                                               91.
C           ---------------------------------------------------           92.
  500       SEARCH = J                                                    93.
            NOFSUB = NOFSUB + DEG(NODE)                                   94.
            MARKER(NODE) = 1                                              95.
            CALL QMDRCH (NODE, XADJ, ADJNCY, DEG, MARKER,                 96.
     1                   RCHSZE, RCHSET, NHDSZE, NBRHD )                  97.
C           ------------------------------------------------              98.
C           ELIMINATE ALL NODES INDISTINGUISHABLE FROM NODE.              99.
C           THEY ARE GIVEN BY NODE, QLINK(NODE), ....                    100.
C           ------------------------------------------------             101.
            NXNODE = NODE                                                102.
  600       NUM = NUM + 1                                                103.
               NP  = INVP(NXNODE)                                        104.
               IP  = PERM(NUM)                                           105.
               PERM(NP) = IP                                             106.
               INVP(IP) = NP                                             107.
               PERM(NUM) = NXNODE                                        108.
               INVP(NXNODE) = NUM                                        109.
               DEG(NXNODE) = - 1                                         110.
               NXNODE = QLINK(NXNODE)                                    111.
            IF (NXNODE .GT. 0) GOTO 600                                  112.
C                                                                        113.
            IF ( RCHSZE .LE. 0 )  GO TO 800                              114.
C              ------------------------------------------------          115.
C              UPDATE THE DEGREES OF THE NODES IN THE REACHABLE          116.
C              SET AND IDENTIFY INDISTINGUISHABLE NODES.                 117.
C              ------------------------------------------------          118.
               CALL  QMDUPD ( XADJ, ADJNCY, RCHSZE, RCHSET, DEG,         119.
     1                        QSIZE, QLINK, MARKER, RCHSET(RCHSZE+1),    120.
     1                        NBRHD(NHDSZE+1) )                          121.
C              -------------------------------------------               122.
C              RESET MARKER VALUE OF NODES IN REACH SET.                 123.
C              UPDATE THRESHOLD VALUE FOR CYCLIC SEARCH.                 124.
C              ALSO CALL QMDQT TO FORM NEW QUOTIENT GRAPH.               125.
C              -------------------------------------------               126.
               MARKER(NODE) = 0                                          127.
               DO 700 IRCH = 1, RCHSZE                                   128.
                  INODE = RCHSET(IRCH)                                   129.
                  IF ( MARKER(INODE) .LT. 0 )  GOTO 700                  130.
                     MARKER(INODE) = 0                                   131.
                     NDEG = DEG(INODE)                                   132.
                     IF ( NDEG .LT. MINDEG )  MINDEG = NDEG              133.
                     IF ( NDEG .GT. THRESH )  GOTO 700                   134.
                        MINDEG = THRESH                                  135.
                        THRESH = NDEG                                    136.
                        SEARCH = INVP(INODE)                             137.
  700          CONTINUE                                                  138.
               IF ( NHDSZE .GT. 0 )  CALL  QMDQT ( NODE, XADJ,           139.
     1            ADJNCY, MARKER, RCHSZE, RCHSET, NBRHD )                140.
  800    IF ( NUM .LT. NEQNS )  GO TO 300                                141.
         RETURN                                                          142.
      END                                                                143.
