C----- SUBROUTINE GENND
C***************************************************************           1.
C***************************************************************           2.
C********     GENND ..... GENERAL NESTED DISSECTION     ********           3.
C***************************************************************           4.
C***************************************************************           5.
C                                                                          6.
C     PURPOSE - SUBROUTINE GENND FINDS A NESTED DISSECTION                 7.
C        ORDERING FOR A GENERAL GRAPH.                                     8.
C                                                                          9.
C                                                                         10.
C     INPUT PARAMETERS -                                                  11.
C        NEQNS - NUMBER OF EQUATIONS.                                     12.
C        (XADJ, ADJNCY) - ADJACENCY STRUCTURE PAIR.                       13.
C                                                                         14.
C     OUTPUT PARAMETERS -                                                 15.
C        PERM - THE NESTED DISSECTION ORDERING.                           16.
C                                                                         17.
C     WORKING PARAMETERS -                                                18.
C        MASK - IS USED TO MASK OFF VARIABLES THAT HAVE                   19.
C               BEEN NUMBERED DURING THE ORDERNG PROCESS.                 20.
C        (XLS, LS) - THIS LEVEL STRUCTURE PAIR IS USED AS                 21.
C               TEMPORARY STORAGE BY FNROOT.                              22.
C                                                                         23.
C     PROGRAM SUBROUTINES -                                               24.
C        FNDSEP, REVRSE.                                                  25.
C                                                                         26.
C***************************************************************          27.
C                                                                         28.
       SUBROUTINE  GENND ( NEQNS, XADJ, ADJNCY, MASK,                     29.
     1                     PERM, XLS, LS )                                30.
C                                                                         31.
C***************************************************************          32.
C                                                                         33.
          INTEGER ADJNCY(1), MASK(1), LS(1), PERM(1),                     34.
     1            XLS(1)                                                  35.
          INTEGER XADJ(1), I, NEQNS, NSEP, NUM, ROOT                      36.
C                                                                         37.
C***************************************************************          38.
C                                                                         39.
          DO 100 I = 1, NEQNS                                             40.
             MASK(I) = 1                                                  41.
  100     CONTINUE                                                        42.
          NUM   = 0                                                       43.
          DO 300 I = 1, NEQNS                                             44.
C            -----------------------------                                45.
C            FOR EACH MASKED COMPONENT ...                                46.
C            -----------------------------                                47.
  200        IF ( MASK(I) .EQ. 0 )  GO TO 300                             48.
                ROOT = I                                                  49.
C               -------------------------------------------               50.
C               FIND A SEPARATOR AND NUMBER THE NODES NEXT.               51.
C               -------------------------------------------               52.
                CALL  FNDSEP ( ROOT, XADJ, ADJNCY, MASK,                  53.
     1                         NSEP, PERM(NUM+1), XLS, LS )               54.
                NUM  = NUM + NSEP                                         55.
                IF ( NUM .GE. NEQNS )  GO TO 400                          56.
                GO TO 200                                                 57.
  300     CONTINUE                                                        58.
C         ----------------------------------------------                  59.
C         SINCE SEPARATORS FOUND FIRST SHOULD BE ORDERED                  60.
C         LAST, ROUTINE REVRSE IS CALLED TO ADJUST THE                    61.
C         ORDERING VECTOR.                                                62.
C         ----------------------------------------------                  63.
  400     CALL  REVRSE ( NEQNS, PERM )                                    64.
          RETURN                                                          65.
       END                                                                66.
