#ifndef lint
static char SCCSid[] = "@(#) ./sparse/gs.c 07/23/93";
#endif

/*
   Routines to perform Gauss-Seidel and symmetric Gauss-Seidel 
   on a sparse matrix  
*/

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"
#include "inline/spops.h"
/*@
        SpGS - Performs m sweeps of Gauss Seidel

  Input Parameters:
    BB - the sparse matrix in SpMatSplit form
    m  - the number of sweeps
    b,x  - the right hand side and solution

@*/
void SpGS( BB, m, b, x)
SpMatSplit  *BB;
double      *x, *b;
int         m;
{
  int      i, n, *nzs;
  double   *v, sum, *vv, *bb, *xx, diag;
  int      *vi, nz;
  int      rnz;
  SpMat    *B = BB->factor;
  
  n      = B->rows;
  while (m--) {
    nzs    = BB->nzl;
    bb     = b;
    xx     = x;
    for (i=0; i<n; i++) {
      SpScatterFromRow( B, i, &rnz, &vi, &v );
      nz   = *nzs;
      sum  = *bb++; 
      SPARSEDENSEMDOT(sum,xx,v,vi,nz);
      v    = v  + *nzs + 1;
      diag = v[-1];
      vi   = vi + *nzs + 1;
      nz   = rnz - *nzs - 1;
      SPARSEDENSEMDOT(sum,xx,v,vi,nz);
      xx[i] = sum / diag;
    }
  }
}
/*@
        SpSGS - Performs m sweeps of symmetric Gauss Seidel

  Input Parameters:
    BB - the sparse matrix in SpMatSplit form
    m  - the number of sweeps
    b,x  - the right hand side and solution

@*/
void SpSGS( BB, m, b, x)
SpMatSplit  *BB;
double      *x, *b;
int         m;
{
  int      i, n, *nzs;
  double   *v, sum, *vv, *bb, *xx, diag;
  int      *vi, nz, rnz;
  SpMat    *B = BB->factor;
  
  n      = B->rows;
  while (m--) {
    nzs    = BB->nzl;
    bb     = b;
    for (i=0; i<n; i++) {
      SpScatterFromRow( B, i, &rnz, &vi, &v );
      nz   = *nzs;
      sum  = *bb++; 
      xx   = x;
      SPARSEDENSEMDOT(sum,xx,v,vi,nz);
      v    = v + *nzs + 1;
      diag = v[-1];
      vi   = vi + *nzs + 1;
      nz   = rnz - *nzs - 1;
      xx    = x;
      SPARSEDENSEMDOT(sum,xx,v,vi,nz);
      xx[i] = sum/diag;
    } 
    nzs--; 
    bb     = b + n - 2;
    for (i=n-2; i>-1; i--) {
      SpScatterFromRow( B, i, &rnz, &vi, &v );
      nz   = *(--nzs);
      sum  = *bb--; 
      xx    = x;
      SPARSEDENSEMDOT(sum,xx,v,vi,nz); 
      v    = v + *nzs + 1;
      diag = v[-1];
      vi   = vi + *nzs + 1;
      nz   = rnz - *nzs - 1;
      xx    = x;
      SPARSEDENSEMDOT(sum,xx,v,vi,nz);
      xx[i] = sum/diag;
    } 
  }
}


