#ifndef lint
static char SCCSid[] = "@(#) ./sparse/group.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"
#include "inline/spops.h"


/*@
   SpMultGroupAdd - Routine for matrix-vector product of special form.

  Description:
  This routine is useful for multi-component problems using a 
2 or multi-level method. If the restriction and interpolation operators
behave the same for all components. Then the SpMat which represents
the operators need only be defined for one component. This routine allows
us to quickly apply the restriction or interpolation for nc components.

  The vectors are assumed to be stored in the form 

$ [ x1 y1 z1 .... x2 y2 z2 ... x3 y3 z3 ..... ] 
The column pointers
of the SpMat point to the location of first x1, then x2 etc. The row map
points in a similar manner.

    Input Parameters:
.      mat - Interpolation or restriction operator
.      v   - input vector
.      nc  - number of components of multicomponent problem.
 
    Output Parameters:
.      vout - output vector
        
 @*/
int SpMultGroupAdd( mat, v, vout, nc )
SpMat    *mat;
double   *v, *vout;
int      nc;
{
           int    i,n, count;
           SpVec  **rs, *row;
  register double *xv, sum0,sum1,sum2,sum3;
  register int    nz, *xi, *rowmap = 0, ir;
  SpRowMat *R = GETROWMAT(mat);

  if (mat->map) rowmap = mat->map->rowmap;
  n      = mat->rows;
  rs     = R->rs;

  if (nc == 1) {
    count = 0;
    while (n--) {
      row  = *rs++;
      xv   = row->v;
      xi   = row->i;
      nz   = row->nz;
      sum0 = 0.0;
      SPARSEDENSEDOT(sum0,v,xv,xi,nz);
      if (rowmap) vout[*rowmap++] += sum0;
      else  vout[count++] += sum0;
    }  
  }
  else if (nc == 2) {
    ir = -2;
    while (n--) {
      row  = *rs++;
      xv   = row->v;
      xi   = row->i;
      nz   = row->nz;
      if (rowmap) ir = *rowmap++; else ir += 2;
      sum0 = vout[ir];
      sum1 = vout[ir+1];
      for( i=0; i<nz; i++) {
        sum0 += xv[i] * v[xi[i]];
        sum1 += xv[i] * v[xi[i]+1];
      }
      vout[ir]     = sum0;
      vout[ir + 1] = sum1;
    }  
  }
  else if (nc == 3) {
    ir = -3;
    while (n--) {
      row  = *rs++;
      xv   = row->v;
      xi   = row->i;
      nz   = row->nz;
      if (rowmap) ir   = *rowmap++; else ir += 3;
      sum0 = vout[ir];
      sum1 = vout[ir+1];
      sum2 = vout[ir+2];
      for( i=0; i<nz; i++) {
        sum0 += xv[i] * v[xi[i]];
        sum1 += xv[i] * v[xi[i]+1];
        sum2 += xv[i] * v[xi[i]+2];
      }
      vout[ir]       = sum0;
      vout[ir + 1]   = sum1;
      vout[ir + 2]   = sum2;
    }  
  }
  else if (nc == 4) {
    ir = -4;
    while (n--) {
      row  = *rs++;
      xv   = row->v;
      xi   = row->i;
      nz   = row->nz;
      if (rowmap) ir   = *rowmap++; else ir += 4;
      sum0 = vout[ir];
      sum1 = vout[ir+1];
      sum2 = vout[ir+2];
      sum3 = vout[ir+3];
      for( i=0; i<nz; i++) {
        sum0 += xv[i] * v[xi[i]];
        sum1 += xv[i] * v[xi[i]+1];
        sum2 += xv[i] * v[xi[i]+2];
        sum3 += xv[i] * v[xi[i]+3];
      }
      vout[ir]       = sum0;
      vout[ir + 1]   = sum1;
      vout[ir + 2]   = sum2;
      vout[ir + 3]   = sum3;
    }  
  }
  else { SETERRC(1,"Invalid number of groups (<=4)"); return -1; }
  return 0;
}
