#ifndef lint
static char SCCSid[] = "@(#) ./sparse/equal.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"
#include <stdio.h>
#include "inline/setval.h"
#include "inline/spops.h"

#define ABS(a)             ((a) < 0.0 ? -(a) : (a))
/*@
   SpEqual - Determines if two matrices are equal.

   Input parameters:
.  A,B - sparse matrices

   Note:
   If matrices are unequal, prints the reason why to stdout.
   Returns 1 if A == B, 0 otherwise
 @*/
int SpEqual( A,B )
SpMat    *A,*B;
{
int      i,j, m;
int      *ia, *ib, nza, nzb;
double   *va, *vb;

m = A->rows;

for (i=0; i<m; i++) {
    SpScatterFromRow( A, i, &nza, &ia, &va );
    SpScatterFromRow( B, i, &nzb, &ib, &vb );
    if (nza != nzb) {
      printf("row %d have different sizes %d %d \n",i,nza,nzb);
      return 0;
    }
    for ( j=0; j<nza; j++ ) {
      if (ia[j] != ib[j]) {
        printf("row %d have different column pointers at %d %d %d\n",i,j,
                         ia[j],ib[j]);
        return 0;
      }
      if (ABS(va[j] - vb[j]) > 1.e-10) {
        printf("row %d have different values  at %d %18.16e %18.16e\n",i,j,
                         va[j],vb[j]);
        return 0;
      }
    }
  }
  return 1;
}

