/*
   A program to test sparse diagonal ops.
 */

#include <stdio.h>
#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/diag/diag.h"
#include <math.h>
extern SpMat *SpDiagToSp();

#define max(a,b) ( ((a)>(b))?a:b )
#define min(a,b) ( ((a)<(b))?a:b )

SpMatDiag *BuildLaplacian();

/* diagtest [ m [ 1=print matrices ] ] */
main( argc, argv )
int  argc;
char **argv;
{
int          n, m, err, pmat;
SpMatDiag    *mat;
SpMat        *mmat;
double       *v, *vsol1, *vsol2;

if (argc > 1) m = atoi( argv[1] );
else m   = 16;
pmat = 0;
if (argc > 2) pmat = atoi( argv[2] );
n   = m * m;
v     = (double *)MALLOC( n * sizeof(double) );
vsol1 = (double *)MALLOC( n * sizeof(double) );
vsol2 = (double *)MALLOC( n * sizeof(double) );
setv( v, n );

/* Try symbolic/numeric separately */
mat  = BuildLaplacian( m );
mmat = SpDiagToSp( mat, m*m, (int *)0, (int *)0 );

if (pmat) {
    printf( "Diagonal form\n" );
    SpDiagPrint( stdout, mat );
    printf( "Row form\n" );
    SpPrint( stdout, mmat );
    }

/* See if matrix-vector multiply generates the same value for each matrix */
SpDiagMult( mat, v, vsol1 );
SpMult( mmat, v, vsol2 );

CompareSolution( vsol1, vsol2, n, m );

/* test free code */
SpMatDiagFree( mat );
}

/* 
   This builds a laplacian with Dirichlet b.c.s .
   A basic routine is 
   AddScalarValues( pd, startrow, n, incr, center, n, s, e, w )
 */
SpMatDiag *BuildLaplacian( m )
int    m;
{
SpMatDiag       *f;
SpDiag          **pd;
double          four, mone, *null = 0;
int             n, i, j, nsd;

n   = m * m;
nsd = m - 2 + 4 + 4;
f   = SpMatDiagAllocate( n, n, nsd );
pd  = f->sd;
four = 4.0;
mone = -1.0;

/* Lower Left corner */
AddScalarValue( pd++, 0, 1, 1, &four, &mone, null, &mone, null, m );
/* Lower Right corner */
AddScalarValue( pd++, m-1, 1, 1, &four, &mone, null, null, &mone, m );
/* Upper Left corner */
AddScalarValue( pd++, m*m-m, 1, 1, &four, null, &mone, &mone, null, m );
/* Upper Right corner */
AddScalarValue( pd++, m*m-1, 1, 1, &four, null, &mone, null, &mone, m );

/* South edge */
AddScalarValue( pd++, 1, m-2, 1, &four, &mone, null, &mone, &mone, m );
/* North edge */
AddScalarValue( pd++, m*m-m+1, m-2, 1, &four, null, &mone, &mone, &mone, m );
/* West edge */
AddScalarValue( pd++, m, m-2, m, &four, &mone, &mone, &mone, null, m );
/* East edge */
AddScalarValue( pd++, 2*m-1, m-2, m, &four, &mone, &mone, null, &mone, m );

/* interior */
for (j=1; j<m-1; j++) {
    AddScalarValue( pd++, j*m + 1, m-2, 1, 
		    &four, &mone, &mone, &mone, &mone, m );
    }
return f;
}

AddScalarValue( pd, sr, n, incr, cn, nn, s, e, w, m )
SpDiag **pd;
int    sr, n, incr, m;
double *cn, *nn, *s, *e, *w;
{
int    nd, *doff;
double *v;

/* count the number of diagonals */
nd   = (cn != 0) + (nn != 0) + (s != 0) + (e != 0) + (w != 0);

*pd  = SpDiagAllocate( sr, n, incr, 1, nd, DIAG_CONSTANT );
doff = (*pd)->doff;
v    = (double *)(*pd)->v;
if (cn) {
    *v++ = *cn;
    *doff++ = sr;
    }
if (nn) {
    *v++ = *nn; 
    *doff++ = sr + m;
    }
if (s) {
    *v++ = *s;
    *doff++ = sr - m;
    }
if (e) {
    *v++ = *e;
    *doff++ = sr + 1;
    }
if (w) {
    *v++ = *w;
    *doff++ = sr - 1;
    }
}

#define EPSILON 1.0e-6
CompareSolution( v1, v2, n, m )
register double *v1, *v2;
register n;
int      m;
{
register double sum = 0.0;
double   *v1save = v1, *v2save = v2;
int      mm;

while (n--) {
    sum += (*v1 - *v2) * (*v1 - *v2);
    v1++; v2++;
    }
printf( "Difference in 2-norm is %f\n", sum );
/* Print WHERE the differences occur */
if (sum > EPSILON) {
    v1 = v1save;
    v2 = v2save;
    mm = m;
    while (m--) {
	n = mm;
	while (n--)
	    printf( "%c", (fabs(*v1++ - *v2++) > EPSILON) ? 'X' : '.' );
	printf( "\n" );
	}
    }
}

setv( v, n )
register double *v;
register int    n;
{
register double val = 0.0;

while (n--) 
    *v++ = val++;
}
