#ifndef lint
static char SCCSid[] = "@(#) ./sparse/costs.c 07/23/93";
#endif

/*
   This file contains routines to compute the cost of various operations
 */

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"

/*@
   SpCostFactor - Return the number of floating point ops to perform a 
                  factorization of a sparse matrix.

   Input Parameter:
.  BB  - matrix
 @*/
int SpCostFactor( BB )
SpMatSplit *BB;
{
int      prow, row, n, nnz, *yi, ops, nz;
SpMat    *BBf = BB->factor;

/* If costs computed by factorization, return those */
if (BB->nf >= 0)
    return BB->nf;

n    = BBf->rows;
ops  = 0;
for (prow=0; prow<n; prow++) {
    SpScatterFromRow( BBf, prow, &nz, &yi, (double **)0 );
    row       = *yi++;
    /* Simulate the elimination.  We need the nz test since it is possible 
       that a zero diagonal may be present in the original row. */
    while (row < prow && --nz) {
	SpScatterFromRow( BBf, row, &nnz, (int **)0, (double **)0 );
	if (!BB->nzl) 
	    nnz = nnz - row - 1;  /* -2 ???? */
	else
	    nnz = nnz - BB->nzl[row] - 1;
	ops       += 2 * nnz + 1;
	row       = *yi++;
	};
    ops++; /* For the inversion of the diagonal */
    }
return ops;
}

/*@
   SpCostSolve - Return the number of floating point ops to perform a
                     solve of a linear system, given a factored matrix.

   Input Parameter:
.  BB  - matrix
 @*/
int SpCostSolve( BB )
SpMatSplit *BB;
{
int          prow, n, ops, nz;
SpMat *BBf = BB->factor;

ops  = 0;
n    = BBf->rows;
for (prow=0; prow<n; prow++) {
    SpScatterFromRow( BBf, prow, &nz, (int **)0, (double **)0 );
    ops       += 2 * nz + 1;
    }
return ops;
}
