#ifndef lint
static char SCCSid[] = "@(#) ./sparse/compress.c 07/23/93";
#endif

#include "tools.h"
#include "spmat.h"
#include "sppriv.h"
#include "inline/copy.h"

/*@C
   SpCompressIfWasteful - If the matrix storages scheme is 
               using alot more memery then expected Produces
                an "optimal" storage of a sparse matrix 
               (allocate exactly the required storage) removes 
               all elements which are smaller then tol

   Input Parameters:
.     AA - matrix to compress
.     ratio - if actual amount of memory used is
                         at least ratio larger then the predicted
                         memory needed, it will perform compress. 
   Output Parameters:
     returns int  1 if compressed, else 0;
 @*/
int SpCompressIfWasteful(AA, ratio)
SpMat  **AA;
double ratio;
{
  double mem, nz;

  nz  = (double) SpNz(*AA);
  mem = (double) SpGetSpaceUsed(*AA);

  if (mem > ratio*nz*(sizeof(double) + sizeof(int))) {
    SpCompress(AA,-1.0);
    return 1;
  }
  return 0;
}
/* -----------------------------------------------------*/
/*@C
   SpCompress - Produce an "optimal" storage of a sparse matrix 
               (allocate exactly the required storage) removes 
               all elements which are smaller then tol

   Input Parameters:
.  AA -  matrix to compress
.  tol - if tol < 0.0 removes no elements
 @*/
int SpCompress(AA, tol)
SpMat  **AA;
double tol;
{
SpMat    *B,*A = *AA;
SpVec    *in, *out;
int      i, j, k, n = A->rows;
register int nz, *iout, *iin;
register double *vout, *vin, ntol = -tol;
SpRowMat *RA = (SpRowMat *)A->data, *RB;

n = A->rows;
B = SpCreate( A->rows, A->cols, 0 ); CHKERRV(1,0);
RB = (SpRowMat *)B->data;
for (i=0; i<n; i++) {
    in   = RA->rs[i];
    vin  = in->v;
    iin  = in->i;
    out  = RB->rs[i];
    
    /* count the number of good entries in the row */
    if (tol >= 0.0) {
	nz = 0;
	for ( j=0; j<in->nz; j++ ) { 
	    if (vin[j] > tol || vin[j] < ntol) nz++;
	    }
	}
    else nz = in->nz;
    
    /* Allocate the destination row */
    if (nz != 0) {
	SPMallocNV( B, nz, &out->v, &out->i ); CHKERRV(1,0);
	}
    else {
	out->v = 0;
	out->i = 0;
	}
    out->nz = out->maxn = nz;
    vout = out->v;
    iout = out->i;
    
    /* Copy the values */
    if (nz > 0) {
	if (tol >= 0.0) {
	    k = 0;
	    for ( j=0; j<in->nz; j++ ) { 
		if (vin[j] > tol || vin[j] < ntol) {
		    vout[k]   = vin[j];
		    iout[k++] = iin[j];
		    }
		}
	    }
	else {
	    MEMCPY(vout,vin,nz*sizeof(double));
	    MEMCPY(iout,iin,nz*sizeof(int));
	    }
	}
    
    /* free the space used in the old row */
    if (in->maxn) SPFreeNV(A,in->maxn,in->v,in->i);
    }

/* If there are mappings, copy them */
if (A->map) {
    B->map = SpCreateMap(); CHKERRV(1,0);
    *B->map = *A->map;
    if (!B->map->q_user_row && B->map->rowmap)
	{B->map->rowmap = SpiDupMapping(B->rows, B->map->rowmap); 
	 CHKERRV(1,0);}
    if (!B->map->q_user_col && B->map->colmap)
	{B->map->colmap = SpiDupMapping( B->cols, B->map->colmap); 
	 CHKERRV(1,0);}
    if (!B->map->q_user_icol && B->map->icolmap)
	{B->map->icolmap = SpiDupMapping(B->cols,B->map->icolmap); 
	 CHKERRV(1,0);}
    }
SpDestroy(A);
*AA = B;
return 0;
}
