#ifndef lint
static char SCCSid[] = "@(#) ./iter/gmres/mmaxpy.c 07/23/93";
#endif

/*
   As the final part of the solution process in gmres, the Krylov 
   vectors are combined together.  This is a block operation, and
   can be more efficiently performed as such.

   This is a basic routine that simply uses the maxpy operation;
   versions that use 2, 4, or more at a time can be found in ...

/*
    This is a multi-maxpy.
    input parameters:
        usrP - tiles
        v1    - vectors to use.  v1, v1+1, ..., v1+nv
        nv    - number of vectors to use, - 1
        p1    - array of multipliers
        dv    - destination for result.
 */
BasicMultiMaxpy( usrP, v1, nv, p1, dv, maxpy )
void   *usrP, **v1, *dv;
int    nv;
double *p1;
int    (*maxpy)();
{
int j;

for (j=0; j<=nv; j++) 
    (*maxpy)( usrP, *p1++, *v1++, dv );
}

