#ifndef lint
static char SCCSid[] = "@(#) ./iter/cg/cgeig.c 07/23/93";
#endif
/*                       

*/
#include <stdio.h>
#include <math.h>
#include "tools.h"
#include "iter/itctx.h"
#include "iter/itfunc.h"
#include "iter/cgctx.h"
#include "iter/itpriv.h"

/* ------------------------------------------------------------------
*      calculates eigenvalues of symmetric tridiagonal
*    matrix stored in vectors d and e. i gives size of system
*    Uses Eispack routine tql1
* -----------------------------------------------------------------*/
#if defined(FORTRANUNDERSCORE)
#define cgtql1 cgtql1_
#elif defined(FORTRANCAPS)
#define cgtql1 CGTQL1 
#endif

static void eig(i,d,e,dd,ee,maxe,mine)
int    i;
double *d,*e,*maxe,*mine,*dd,*ee;
{
   int j, 
       ii;      /* ii lets us take the address of i; there have been some
		   problems with some systems */

   /* copy tridiagonal matrix to work space */
   ii = i;
   for ( j=0; j<ii ; j++) { dd[j] = d[j]; ee[j] = e[j]; }

   cgtql1(&ii,dd,ee,&j);
   if (j != 0) SETERRC(1,"Error return from tql1 in CG code");  

   *mine = dd[0]; *maxe = dd[ii-1];
}

/*@
    ITCGGetEigenvalues - After runing ITCGSolve() or ITSolve()
    calling this routine will return the extreme eigenvalues of the 
    preconditioned problem as calculated by Lanczo. One must call 
    ITSetCalculateEigenvalues() before call ITCGSetUp() or ITSetUp() 
    in order for this to work.
  
    Input Parameters:
.    itP  -  iterative context
.    n    - number of iterations of CG run
    
    Output Parameters:
.    emax,emin  - the extreme eigenvalues
@*/
void ITCGGetEigenvalues(itP,n,emax,emin)
ITCntx *itP;
double *emax,*emin;
int    n;
{
  CGCntx *cgP;

  if (itP->method != ITCG) {SETERRC(3,"Method not CG");return;}
  if (!itP->calc_eigs) {
      SETERRC(4,"Eigenvalue calculation not requested in CG Setup");return;}

  cgP = (CGCntx *) itP->MethodPrivate;
  if (n == 0) {
      *emax = *emin = 1.0;
      return;
      }

  eig(n,cgP->d,cgP->e,cgP->dd,cgP->ee,emax,emin); 
}
