#ifndef lint
static char SCCSid[] = "@(#) ./comm/htable/p4pgm.c 07/23/93";
#endif

#include <stdio.h>
#include <time.h>
#include <sys/param.h>
#include <sys/time.h>
/* 
  From sys/param.h:
 x #define	MAXPATHLEN	1024
 x #define	MAXHOSTNAMELEN  64
 */
#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

#include "tools.h"
#include "comm/hosts.h"
#include "comm/htable/bhost.h"

/*D
     p4pgm - produce a p4 procgroup file on standard output, given a 
     requested number of processors and an architecture.  Later, we'll
     allow cpu and memory limits to be specified.

     Options:
.     -np n       Number of processors
.     -arch name  Architecture name
.     -exes name  Name of program (fully qualified)
.     -cpu  min   minutes of cpu time
.     -mem  mb    megabytes of memory
.     -pf   n     number of pagefaults
.     -dbg        write out the decision process (debugging)
D*/
main( argc, argv )
int  argc;
char **argv;
{
FILE *fin;
int  np, cpu, mem, pf, dbg;
char arch[20];
char pname[MAXPATHLEN];
char hostfname[MAXPATHLEN];
struct timeval maxtime;
HOSTEntry *plist;
int       nl;
char      pgm[MAXPATHLEN];

dbg = 0;
strcpy( pname, "/usr/local/example" );
SYGetResourceDefaults( &cpu, &mem, &pf, (int *)0, (int *)0 );
SYArgsToResources( &argc, argv, &np, &dbg, arch, pname );
SYGetResourceLimits( &argc, argv, &cpu, &mem, &pf, &maxtime, 1 );
PIBuildPgmName( pname, arch, pgm );

argv++;
while (--argc) {
    if (strcmp( "-help", argv[0]) == 0) {
	fprintf( stderr, "p4pgm -arch name -np n -exes name\n" );
        exit(0);
        }
    else {
        fprintf( stderr, "Unrecognized arg %s\n", argv[0] );
        exit(1);
        }
    argv++;
    }
SYGetFileFromEnvironment( "TOOLSHOST", 
			  DEFAULTTOOLSHOSTS, 
			  "hosts", hostfname, 'r' );

fin = fopen( hostfname, "r" );
if (!fin) {
    fprintf( stderr, "Can not open hosts file\n" );
    exit(1);
    }
plist = (HOSTEntry *)MALLOC( np * sizeof(HOSTEntry) );     CHKPTR(plist);
nl    = PIBuildHostList( np-1, fin, arch, mem, cpu, pf, dbg, plist );
PIWriteP4PG( stdout, nl, plist, pgm );
}

PIWriteP4PG( fout, nl, plist, pgm )
FILE      *fout;
int       nl;
HOSTEntry *plist;
char      *pgm;
{
int i;

fprintf( fout, "local 0\n" );
for (i=0; i<nl; i++) 
    fprintf( fout, "%s %d %s\n", plist[i].name, plist[i].np, pgm );
}
