/* 
   IBM EUI interface, using the EUI-level 1 routines

   UNDER CONSTRUCTION

   Pending changes:
   ASYNCRecvId_t should be a pointer to a structure that holds the type and
   source (since these values are returned asynchronously).  A simple heap of
   such structures can be allocated; by using the pointer, they will work 
   even for Fortran users.

   We may need to convert from a tag of -1 to DONTCARE

   We may need to call mpc_task_query to get ALLGRP and DONTCARE

   We may need our routines for I_VADD etc.
 */

#ifndef __commeui
#define __commeui

/* #include <mp_eui.h> */
/* Note that mp_eui doesn't check to see if it has already been included... */
/* Note also that mp_eui.h is INCOMPATIBLE with POSIX_SOURCE (needed by PETSc).
   Thus, we include */
#include <sys/types.h>
typedef ulong_t ulong;
#include <mp_eui.h>

#ifndef __commh
#include "comm/comm.h"
#endif

extern int __EUILEN, __EUIFROM, __EUITYPE;
extern int __NUMNODES, __MYPROCID;


#define MSG_INT   0
#define MSG_LNG   1
#define MSG_FLT   2
#define MSG_DBL   3
#define MSG_OTHER 4
#define MSG_SHRT  5

/*
   The C interface seems to call the Fortran interface so why not use
   the Fortran interface directly. 
*/
/*#define USE_EUI_FORTRAN_INTERFACE */

/* There are native global ops; I just haven't included them yet */
#define NO_NATIVE_GLOBAL
#define NO_FORCE

/* Notes on these routines:
   The recv routines return information on the type, len, and source
   in the arguments used to pass those values as selectors.  Thus
   we need to copy those values to temps before calling the receive routines
 */   
#if defined(USE_FORTRAN_INTERFACE)
#define SENDSYNC(type,buffer,length,to,datatype) \
         { int __l = length, __t = to, __ty = type; \
         LOGSENDSTART(length,type,to);\
	     mp_bsend(buffer,&__l,&__t,&__ty));}\
         LOGSENDEND(type);}
#else
#define SENDSYNC(type,buffer,length,to,datatype) \
        {LOGSENDSTART(length,type,to);\
	     mpc_bsend(buffer,length,to,type);\
         LOGSENDEND(type);}
#endif
#if defined(USE_FORTRAN_INTERFACE)
#define RECVSYNC(type,buffer,length,datatype) {int __l = length; \
        __EUIFROM=DONTCARE;\
        __EUITYPE=type; LOGRECVSTART(type);\
        mp_brecv(buffer,&__l,&__EUIFROM,&__EUITYPE,&__EUILEN);\
        LOGRECVEND(type,__EUILEN,__EUIFROM);}
#else
#define RECVSYNC(type,buffer,length,datatype) {__EUIFROM=DONTCARE;\
        __EUITYPE=type;; LOGRECVSTART(type);\
        mpc_brecv(buffer,length,&__EUIFROM,&__EUITYPE,&__EUILEN);\
        LOGRECVEND(type,__EUILEN,__EUIFROM);}
#endif
#define SENDSYNCNOMEM(type,buffer,length,to,datatype) \
        SENDSYNC(type,buffer,length,to,datatype)
#define RECVSYNCNOMEM(type,buffer,length,datatype)  \
        RECVSYNC(type,buffer,length,datatype);
#if defined(USE_FORTRAN_INTERFACE)
#define RECVSYNCUNSZ(type,bufp,size,datatype) {\
        do {__EUIFROM=DONTCARE;__EUITYPE=type;\
	    mp_probe(&__EUIFROM,&__EUITYPE,&__EUILEN);}while(__EUILEN<0);\
        bufp=(char*)MALLOC(__EUILEN);\
        RECVSYNC(type,bufp,__EUILEN,datatype);}
#else
#define RECVSYNCUNSZ(type,bufp,size,datatype) {\
        do {__EUIFROM=DONTCARE;__EUITYPE=type;\
	    mpc_probe(&__EUIFROM,&__EUITYPE,&__EUILEN);}while(__EUILEN<0);\
        bufp=(char*)MALLOC(__EUILEN);\
        RECVSYNC(type,bufp,__EUILEN,datatype);}
#endif

typedef int ASYNCRecvId_t;
/* Eventually, need:
typedef struct { int recvlen, id; } ASYNCRecvId_t;
 */
typedef int ASYNCSendId_t;
/* Asynchronous routines */
#if defined(USE_FORTRAN_INTERFACE)
#define SENDASYNC(type,buffer,length,to,datatype,id) \
        {LOGSENDSTART(length,type,to);\
         int __ty = type, __l = length; __t = to; \ 
	     mpc_send(buffer,&__l,&__t,&__ty,&(id));\
		 LOGSENDEND(type);}
#else
#define SENDASYNC(type,buffer,length,to,datatype,id) \
        {LOGSENDSTART(length,type,to);\
	     mpc_send(buffer,length,to,type,&(id));\
		 LOGSENDEND(type);}
#endif
/* Design problem:  __EUIFROM will be set when the message comes in.
   Thus we really need to modify AsyncRecvId_t to be a structure
   containing the source field! */
#if defined(USE_FORTRAN_INTERFACE)
#define RECVASYNC(type,buffer,length,datatype,id) \
     {int __l = length; __EUIFROM=DONTCARE;__EUITYPE=type;\
     mpc_recv(buffer,&__l,&__EUIFROM,&__EUITYPE,&(id));}
#else
#define RECVASYNC(type,buffer,length,datatype,id) \
     {__EUIFROM=DONTCARE;__EUITYPE=type;\
     mpc_recv(buffer,length,&__EUIFROM,&__EUITYPE,&(id));}
#endif
#if defined(USE_FORTRAN_INTERFACE)
#define SENDWAIT(type,buffer,length,to,datatype,id) {\
	int d; mp_wait(&(id),&d);}
#else
#define SENDWAIT(type,buffer,length,to,datatype,id) {\
	int d; mpc_wait(&(id),&d);}
#endif
#if defined(USE_FORTRAN_INTERFACE)
#define RECVWAIT(type,buffer,length,datatype,id)     \
        {LOGRECVWAIT(type);mp_wait(&(id),&__EUILEN);\
	     LOGRECVREADY(type);\
	     LOGRECVSTART(type);LOGRECVEND(type,__EUILEN,-1);}
#else
#define RECVWAIT(type,buffer,length,datatype,id)     \
        {LOGRECVWAIT(type);mpc_wait(&(id),&__EUILEN);\
	     LOGRECVREADY(type);\
	     LOGRECVSTART(type);LOGRECVEND(type,__EUILEN,-1);}
#endif
#define SENDASYNCNOMEM(type,buffer,length,to,datatype,id) \
        SENDASYNC(type,buffer,length,to,datatype,id)
#define RECVASYNCNOMEM(type,buffer,length,datatype,id) \
        RECVASYNC(type,buffer,length,dataype,id)
#define SENDWAITNOMEM(type,buffer,length,to,datatype,id)  \
        SENDWAIT(type,buffer,length,to,datatype,id)  
#define RECVWAITNOMEM(type,buffer,length,datatype,id)     \
        RECVWAIT(type,buffer,length,datatype,id)
/* does this have Fortran version?? */
#define ASYNCPROBE(type) mppi_asyncprobe(type)
#if defined(USE_FORTRAN_INTERFACE)
#define ASYNCDONE(id)    mp_status(&(id))
#else
#define ASYNCDONE(id)    mpc_status(&(id))
#endif
#if defined(USE_FORTRAN_INTERFACE)
#define RECVCANCEL(id)   mp_cancel(&(id))
#define SENDCANCEL(id)   mp_cancel(&(id))
#else
#define RECVCANCEL(id)   mpc_cancel(id)
#define SENDCANCEL(id)   mpc_cancel(id)
#endif

/* No Forcetype routines.  */
#if defined(USE_FORTRAN_INTERFACE)
#define SYNCPROBE(type) {int __t = type; do {\
   __EUIFROM=DONTCARE;mpc_probe(&__EUIFROM,&__t,&__EUILEN);}while(__EUILEN<0);}}
#else
#define SYNCPROBE(type) {do {\
   __EUIFROM=DONTCARE;mpc_probe(&__EUIFROM,type,&__EUILEN);}while(__EUILEN<0);}
#endif
#define RECVPROBED(type,buffer,length,datatype) \
        RECVSYNC(type,buffer,length,datatype)
/* Note: mpc_cancel missing from June 28 draft of EUI */

#define RECVLEN()  __EUILEN
#define RECVFROM() __EUIFROM
#define RECVTYPE() __EUITYPE

#define MSGALLOCSEND(msg,maxmsg,type)  msg = (type *)MALLOC(maxmsg)
#define MSGFREESEND(msg)               FREE(msg)
#define MSGALLOCRECV(msg,maxmsg,type)  msg = (type *)MALLOC(maxmsg)
#define MSGFREERECV(msg)               FREE(msg)

/* 
   There are global operations, even on subsets!
   This will require some support by procset, since the procset code
   assumed that no-one would provide this functionality.  Procset
   should provide hooks for this, and there should be a procset 
   implementation layer.

   Problems:
   MPC_REDUCE is a "half reduction"; like the PICL versions.
   MPC_COMBINE is the full reduction.
   
   For now, we'll leave support for these operations out.
   
 */
#ifdef EUI_GLOBAL_AVAILABLE
/* #define GSCATTERGLOB(buf,size,issrc,datatype) */
#define GSCATTERSRCGLOB(buf,size,src,datatype) \
    mpc_bcast( buf, size, src, ALLGRP )
#define GSYNCGLOB() mpc_sync(ALLGRP)
#define GISUMGLOB(val,n,work) \
    mpc_combine(val,I_VADD,n*sizeof(int),val,ALLGRP)
#define GDSUMGLOB(val,n,work) \
    mpc_combine(val,D_ADD,n*sizeof(double),val,ALLGRP)
#define GFSUMGLOB(val,n,work) \
    mpc_combine(val,F_ADD,n*sizeof(float),val,ALLGRP)
#define GIMAXGLOB(val,n,work) \
    mpc_combine(val,I_MAX,n*sizeof(int),val,ALLGRP)
#define GDMAXGLOB(val,n,work) \
    mpc_combine(val,D_MAX,n*sizeof(double),val,ALLGRP)
#define GIMINGLOB(val,n,work) \
    mpc_combine(val,I_MIN,n*sizeof(int),val,ALLGRP)
#define GDMINGLOB(val,n,work) \
    mpc_combine(val,D_MIN,n*sizeof(double),val,ALLGRP)
#define GIORGLOB(val,n,work) \
    mpc_combine(val,I_OR,n*sizeof(int),val,ALLGRP)
#endif

/* NUMNODES and MYPROCID need to be set by the init routine */
#define NUMNODES __NUMNODES
#define MYPROCID __MYPROCID
#define MSGTYPERANGE(low,high) {int nbuf[2];mpc_task_query(nbuf,2,2);\
				    *(low)=nbuf[0];*(high)=nbuf[1];}
#define MSGDISTANCE(from,to)   (from != to)
#define MSGDIAMETER            (1)

#endif


