/* Generic values.  These are appropriate for a uni-processor */
#ifndef __commdef
#define __commdef

#ifndef __commh
#include "comm/comm.h"
#endif

#define MSG_INT   0
#define MSG_LNG   1
#define MSG_FLT   2
#define MSG_DBL   3
#define MSG_OTHER 4
#define MSG_SHRT  5

#define NO_FORCE
#define NO_ASYNC_SEND
#define NO_ASYNC_RECV

#define SENDSYNC(type,buffer,length,to,datatype) 
#define RECVSYNC(type,buffer,length,datatype)  
#define SENDSYNCNOMEM(type,buffer,length,to,datatype) 
#define RECVSYNCNOMEM(type,buffer,length,datatype)  

#define SYNCPROBE(type) 
#define ASYNCPROBE(type) 0
#define RECVPROBED(type,buffer,length,datatype)

#define RECVLEN()  0
#define RECVFROM() 0
#define NUMNODES   1
#define MYPROCID   0

/* We will use the min of known types here */
#define MSGTYPERANGE(low,high) {*(low)=0;*(high)=1000000000;}
#define MSGDISTANCE(from,to)   gdistdf(from,to)
#define MSGDIAMETER            0
#define MSGSIZES(min,max)      {*min=sizeof(int);*max=(16384*8096);}

#define GISUM(val,n,work,procset)  
#define GDSUM(val,n,work,procset)  
#define GIMAX(val,n,work,procset)  
#define GIMIN(val,n,work,procset)  
#define GDMAX(val,n,work,procset)  
#define GDMIN(val,n,work,procset)  
#define GIOR(val,n,work,procset)
#define GSYNC(procset)             
#define GCOL(lbuf,lsize,gbuf,gsiz,glen,procset,datatype) \
       {MEMCPY(gbuf,lbuf,lsize);*glen=lsize;}
#define GCOLX(lbuf,gsizes,gbuf,procset,datatype) \
       {MEMCPY(gbuf,lbuf,gsizes[0]);}
#define GTOKEN(procset,i) ((i)==0)
#define GSCATTER(buf,siz,issrc,procset,datatype) 

#define MSGALLOCSEND(msg,max,type)  msg = (type *)MALLOC(max)
#define MSGFREESEND(msg)               FREE(msg)
#define MSGALLOCRECV(msg,max,type)  msg = (type *)MALLOC(max)
#define MSGFREERECV(msg)               FREE(msg)

#endif
