#ifndef lint
static char SCCSid[] = "@(#) ./comm/args.c 07/23/93";
#endif

#include "tools.h"
#include "comm/procset.h"
#include "comm/comm.h"

/*
   This file contains routines to pass an Unix-style argument structure
   between machines.  The form is two arrays: an integer array that
   contains the number of arguments and their lengths, and a 
   character array that contains all of the arguments.  This is
   transportable across networks of dis-similar machines
 */

/* Suppress any output from this routine, even if tracing is enabled.
   See logging.h for the reason this will 
#ifdef LPRINTG
#undef LPRINTG
#endif
#define LPRINTG(a,n)

/*+
    PIBroadcastArgs - Broadcast the argument vector to every processor in
    a processor subset.

    Input Parameters:
.    argc,argv - pointers to the usual argc, argv
.    is_sender  - 1 if sender, 0 for all other processors
.    procset    - processor subset
+*/
void PIBroadcastArgs( argc, argv, is_sender, procset )
int  *argc, is_sender;
char ***argv;
ProcSet *procset;
{
int  *arglen, i, narg, nlen;
char *argstr, *p;

GSCATTER(argc,sizeof(int),is_sender,procset,MSG_INT);
narg   = *argc;
arglen = (int *)MALLOC( narg * sizeof(int) );
if (is_sender) {
    for (i=0; i<narg; i++) 
	arglen[i] = strlen((*argv)[i]) + 1;  /* Add in the string terminator */
    }
GSCATTER(arglen,sizeof(int)*narg,is_sender,procset,MSG_INT);
nlen = 0;
for (i=0; i<narg; i++) 
    nlen += arglen[i];
/* printf( "[%d] arglen = %d\n", MYPROCID, nlen ); */

argstr = (char *)MALLOC( nlen );
if (is_sender) {
    p = argstr;
    for (i=0; i<narg; i++) {
	strcpy( p, (*argv)[i] );
	p  += arglen[i];
	}
    }
GSCATTER(argstr,nlen,is_sender,procset,MSG_OTHER);
if (!is_sender) {
    /* Unpack into the argv string */
    *argv = (char **) MALLOC( nlen * sizeof(char *) );
    p = argstr;
    for (i=0; i<narg; i++) {
	(*argv)[i] = p;
	p += arglen[i];
	}
    }
else
    FREE(argstr);
FREE(arglen);
}

#ifndef __MSDOS__
#include <sys/time.h>
#else
struct timeval { unsigned long tv_usec, tv_sec; };
#endif
/*
   This handles sending the limits around
 */
PIBroadcastLimits( cpu, mem, pf, maxtime, niceval, is_sender, procset )
int *cpu, *mem, *pf, *niceval, is_sender;
struct timeval *maxtime;
ProcSet *procset;
{
long limits[6];

if (is_sender) {
    limits[0] = *cpu;
    limits[1] = *mem;
    limits[2] = *pf;
    limits[3] = maxtime->tv_sec;
    limits[4] = maxtime->tv_usec;
    limits[5] = *niceval;
    }
/* The logpush/disable here only affects the generation of event logs */
LOGpush(); LOGDISABLE;
GSCATTER( limits, 6*sizeof(long), is_sender, procset, MSG_LNG );
LOGpop();
if (!is_sender) {
    *cpu             = limits[0];
    *mem             = limits[1]; 
    *pf              = limits[2]; 
    maxtime->tv_sec  = limits[3]; 
    maxtime->tv_usec = limits[4]; 
    *niceval         = limits[5];
    }
}
