#ifndef lint
static char SCCSid2[] = "@(#) ./c2fort/lftslv.c 07/23/93";
#endif

#ifndef DEBUG_ALL
#define DEBUG_ALL
#endif

/* 
   This file contains those routines whose translation into Fortran
   could not be handled by the automatic translator.  Some of them
   are not supported in Fortran.
 */
#include "tools.h"
#include "solvers/svctx.h"

#if defined(FORTRANCAPS)
#define svgeticcalpha_ SVGETICCALPHA
#define svgetflops_    SVGETFLOPS
#define spcreate_      SPCREATE
#define svsetmonitor_  SVSETMONITOR
#define svsetconvergencetest_ SVSETCONVERGENCETEST
#define cvttovoid_     CVTTOVOID
#define spcompress_    SPCOMPRESS
#define spcompressifwasteful_ SPCOMPRESSIFWASTEFUL

#elif !defined(FORTRANUNDERSCORE)
#define svgeticcalpha_ svgeticcalpha
#define svgetflops_    svgetflops
#define spcreate_      spcreate
#define svsetmonitor_  svsetmonitor
#define svsetconvergencetest_ svsetconvergencetest
#define cvttovoid_     cvttovoid
#define spcompress_    spcompress
#define spcompressifwasteful_ spcompressifwasteful
#endif

void svgeticcalpha_(C,a)
SVctx **C;
int   *a;
{
int b;
SVGetICCAlpha(*C,b);
*a = b;
}
void svgetflops_( C, a ) 
SVctx **C;
int   *a;
{
int b;
SVGetFlops(*C,b);
*a = b;
}
void svgetmemory_( C, a ) 
SVctx **C;
int   *a;
{
int b;
SVGetMemory(*C,b);
*a = b;
}

/* These need to stash the user function away and call a special stub routine 
 */
static struct { int (*converge)(); } LocalConverge;
int SViFtoCConverge( itP, usrP, it, res )
void *itP, *usrP;
int  it;
double res;
{
int itp     = it;
double resp = res;
return (*LocalConverge.converge)( itP, usrP, &itp, &resp );
}
void svsetconvergencetest_( C, a, b )
SVctx **C;
int   (*a)();
void   *b;
{
LocalConverge.converge = a;
SVSetConvergenceTest( *C, SViFtoCConverge, (void *)&LocalConverge );
}

static struct { void (*monitor)(); } LocalMonitor;
void SViFtoCMonitor( itP, usrP, it, res )
void *itP, *usrP;
int  it;
double res;
{
int itp     = it;
double resp = res;
(*LocalMonitor.monitor)( itP, usrP, &itp, &resp );
}
void svsetmonitor_( C, a, b )
SVctx **C;
void  (*a)(), *b;
{
/* Handle the null pointer */
if ((int)(a) == 0) {
    SVSetMonitor( *C, (void (*)())0, (void *)0 );
    }
else {
    LocalMonitor.monitor = a;
    SVSetMonitor( *C, SViFtoCMonitor, (void *)&LocalMonitor );
    }
}

#include "sparse/spmat.h"
int spcreate_( N, M, NMAX )
int *N, *M, *NMAX;
{
return (int)SpCreate( *N, *M, *NMAX );
}

/* This routine takes an address and dereferences it once */
void *cvttovoid_( n )
int **n;
{
return (void *)**n;
}

/* Because these are passed the addresses of the SpMat pointers, we don't
   need to de-ref them */
int spcompressifwasteful_(AA, ratio)
SpMat  **AA;
double *ratio;
{
return SpCompressIfWasteful(AA,*ratio);
}
int spcompress_(AA, tol)
SpMat  **AA;
double *tol;
{
return SpCompress(AA,*tol);
}
