/* @(#) ./blkcm/bc.h 07/23/93 */

#ifndef __BC
#define __BC

/* Choose general types based on specific architectures */
#include "comm/comm.h"
#ifdef DISTRIBUTED_MEMORY
#define PARALLEL_VERSION
#endif

typedef int (*intfunc)();

typedef struct {
    int    version,             /* version of program */
           iscompiled,          /* has program been compiled */
           isrunning,           /* is it running (for recursive calls) */
           n,                   /* size of program */
           ndecl,               /* size of program storage (n <= ndecl) */
           options,             /* compilation options */
           basetype,            /* Base message type for message passing
				   implementations */
           maxdim;              /* keeps track of max dim of data sections */
    ProcSet *ps;                /* Processor set to act in */
    intfunc Error,              /* routine to handle errors */
            in, out, copy;      /* Routines to move data around */
    struct BC_entry *pgm, *pgm_last;

    /* routines to manage processing of the program */
    intfunc irecv, isend, iwait, compile, 
	    irun;      /* Optional routine to do processing between send
			  and wait on receive (for nonblocking receive case
                          only) */
    void    *irunctx;  /* Data to pass to irun */

    intfunc valid, trimmove, inplace, pairsync, buffer, findowner, sort,
            settypes, findlocal, schedule;

    /* Routine to find a line in the program */
    struct BC_entry *(*getline)();

    /* Routine to compute actual address from local context and program
       context */
    double *(*GetAddressSrc)(), *(*GetAddressDest)();

    /* basedims is used to help print out the program in an understandable
       format */
    int basend, basedims[5];

    /* As is offsettype (used to help print easily read program output) */
    int offsettype; 

    struct BC_entry *pgm_cur;    /* Current location when executing,
				    may be start of a phase */

    void   *ExecCtx;             /* Pointer to execution context, if any.
				    This can be used to run a BlockComm
				    program in a separate thread, for example.
				  */
    } BCPGM;

#define BCVERSION            1
#define BCOPTION_BUFFER      0x0001
#define BCOPTION_PAIRSYNC    0x0002
#define BCOPTION_NOAUTOTYPE  0x0004
#define BCOPTION_NOVALID     0x0008
#define BCOPTION_NOSORT      0x0010
#define BCOPTION_INPLACE     0x0020
#define BCOPTION_TRIMMOVE    0x0040
#define BCOPTION_NOFINDOWNER 0x0080
#define BCOPTION_SRCADDRESS  0x0100
#define BCOPTION_DESTADDRESS 0x0200
#define BCOPTION_OPTMOVES    0x0400
#define BCOPTION_NOFINDLOCAL 0x0800
#define BCOPTION_NOSCHEDULE  0x1000

/* These are all of the valid bits for options */
#define BCOPTION_BITS        0x1fff

#define BCNO_ERROR           0
/* Switch to "tools" form of error numbers.  Should register "BC" as
   0x100000 */
#define ERR_NO_PGM_LINE    0x10001

/* Major instructions (SRC is SEND, DEST is RECV) */
#define BLOCK_COMM_SRC       0x002
#define BLOCK_COMM_DEST      0x001

/* Routine declarations (should provide a version with prototypes) */
BCPGM *BCalloc();
BCPGM *BCsubset();
BCPGM *BCcopy();

/* These are macros for the ROUTINES to perform various optimizations.
   This allows the user to keep the size of the executable down
 */
#define BCoptionBuffer 
#define BCoptionPairSync
#define BCoptionAutoType
#define BCoptionNoValid
#define BCoptionNoSort
#define BCoptionInPlace
#define BCoptionTrimMove
#define BCoptionFindOwner

#endif
