#include <stdio.h>
#include "tools.h"
#include "xtools/basex11.h"

#include <math.h>

#define X_SIZE 11
#define Y_SIZE 13

main( argc, argv )
int argc;
char **argv;
{
XBWindow *XBWin;
double   mesh[X_SIZE*Y_SIZE], x[X_SIZE], y[Y_SIZE], r;
double   mat[16], permat[16];
int      i, j;
double   theta, phi, work[4*(X_SIZE+Y_SIZE)];
int      px = -1, py = -1, pw = 200, ph = 200;

XBWin = XBWinCreate();
if (SYArgHasName( &argc, argv, 1, "-help" )) {
    fprintf( stderr, "%s Rotating surface example\n", argv[0] );
    exit(0);
    }
XBGetArgs( &argc, argv, 1, &px, &py, &pw, &ph );
if (XBQuickWindow( XBWin, "", "Surface", px, py, pw, ph )) {
    fprintf( stderr, "Check your DISPLAY variable\n" );
    exit(0);
    }
XBInitDblBuf( XBWin );

/* Setup the data */
for (i=0; i<X_SIZE; i++) x[i] = i*(1.0/(X_SIZE-1));
for (j=0; j<Y_SIZE; j++) y[j] = j*(1.0/(Y_SIZE-1));
for (i=0; i<X_SIZE; i++)
    for(j=0; j<Y_SIZE; j++) {
        r = sqrt( (x[i] - 0.5) * (x[i] - 0.5) + (y[j] - 0.5) * (y[j] - 0.5));
        mesh[i + j * X_SIZE] = (r == 0) ? 1.0 : sin(4.0*r) / (4.0 * r);
        }

r     = 10.0;
theta = 30.0;
phi   = 60.0;
for (i=0; i<60; i++) {
    theta += 5.0;
    XBSurfaceComputeView( r, theta, phi, mat, permat );
    XBClearWindow( XBWin, 0, 0, XBWin->w, XBWin->h );
    XSetForeground( XBWin->disp, XBWin->gc.set, XBWin->foreground );
    XBSurfaceDraw( XBWin, mesh, x, y, work, X_SIZE, Y_SIZE, mat, permat, 
                   XBWin->w, XBWin->h );
    XBFlush( XBWin );
    }
}
