#ifndef lint
static char SCCSid[] = "@(#) ./xtools/apps/xfunc.c 07/23/93";
#endif

#include <math.h>
#include "tools.h"
#include "iter/itall.h"
#include "xtools/basex11.h"
#include "xtools/lines/lines.h"
#include "xtools/axis/axis.h"

/*
   This file contains a routine to display a function of many variables
   by taking a 2-d slice through it.  The slice is defined by two
   (not necessarily orthonormal) vectors.

   This is the algorithm:
   Given two vectors x and z, normalize them.
   Compute y as z - (x,z)x .  Normalize y.  These are the coordinate 
   directions.
   
   A mesh is now defined as (x0 + x*ih, y0 + x*jk) for (x0,y0) the components
   of a center vector in the given coordinate system, (h,k) step sizes,
   and (i,j) 
*/

void XBFind2dCoords();


void XBFunContour( n, c, x, y, nx, ny, rx, ry, fcn, nc )
double *c, *x, *y, rx, ry;
double (*fcn)();
int    n, nx, ny, nc;
{
double *xn, *yn, *xloc, *fn, *mesh, sum, hx, hy, *xi, *yi;
int    i, j, k;

/* Allocate temps to hold the vectors */
xn   = (double *)MALLOC( n * 3 * sizeof(double) );    CHKPTR(xn);
yn   = xn + n;
xloc = yn + n;

XBFind2dCoords( n, x, y, xn, yn );

/* Now we have the coordinate system.  Generate the mesh of values */
mesh = (double *)MALLOC( nx * ny * sizeof(double) );     CHKPTR(mesh);
fn   = mesh;
xi   = (double *)MALLOC( (nx + ny) * sizeof(double) );   CHKPTR(xi);
yi   = xi + nx;
hx   = 2.0 * rx / (nx-1);
hy   = 2.0 * ry / (ny-1);
for (i=0; i<nx; i++) 
    xi[i] = (i - (nx-1)/2) * hx;
for (j=0; j<ny; j++) {
    yi[j] = (j - (ny-1)/2) * hy;
    for (i=0; i<nx; i++) {
	for (k = 0; k<n; k++) 
	    xloc[k] = c[k] + xn[k] * xi[i] + yn[k] * yi[j];
	*fn++ = fcn( n, xloc );
	}
    }

/* Finally, we are ready to plot the contour */
XBQContour( mesh, xi, yi, nx, ny, nc );

FREE(mesh);
FREE(xi);
FREE(xn);
}


/* 
  Compute a 2-d coordinate system (actually just the axis vectors)
  given two vectors in the plane. 
 */
void XBFind2dCoords( n, x, y, xx, yy )
double *x, *y, *xx, *yy;
int    n;
{
double sum;
int    i;

for (i=0; i<n; i++) {
    xx[i] = x[i];
    yy[i] = y[i];
    }

/* Normalize them */
sum = 0.0;
for (i=0; i<n; i++) sum += xx[i] * xx[i];
sum = sqrt( sum );
for (i=0; i<n; i++) xx[i] /= sum;

/* Make y orthogonal to x */
sum = 0.0;
for (i=0; i<n; i++) sum += yy[i] * xx[i];
for (i=0; i<n; i++) yy[i] -= sum * xx[i];

sum = 0.0;
for (i=0; i<n; i++) sum += yy[i] * yy[i];
sum = sqrt( sum );
for (i=0; i<n; i++) yy[i] /= sum;
}

/* Draw s from c on the same plot */
void XBFunDrawLine( n, c, x, y, rx, ry, s )
int    n;
double *c, *x, *y, *s, rx, ry;
{
double *xx, *yy, sum;
double x0[2], x1[2];
int    i;

xx = (double *)MALLOC( 2 * n * sizeof(double) );
yy = xx + n;
XBFind2dCoords( n, x, y, xx, yy );
x0[0] = x1[0] = 0.0;
sum = 0.0;
for (i=0; i<n; i++) sum += s[i] * xx[i];
x0[1] = sum;
sum = 0.0;
for (i=0; i<n; i++) sum += s[i] * yy[i];
x1[1] = sum;

XBQLineSingle( -rx, rx, -ry, ry, x0, x1 );
FREE( xx );
}


/* 
   Draw a line from x to y given xmin, etc
 */
XBQLineSingle( xmin, xmax, ymin, ymax, x, y )
double xmin, xmax, ymin, ymax, *x, *y;
{
XPoint          pts[2];
double          xscale, yscale;
int             i;
XBWindow *XBWin = XBQGetWindow( "Lines", "" );

xscale = XBWin->w / (xmax - xmin);
yscale = XBWin->h / (ymax - ymin);
for (i=0; i<2; i++) {
    pts[i].x = XBWin->x + (x[i] - xmin) * xscale;
    pts[i].y = XBWin->y + (y[i] - ymin) * yscale;
    }
XDrawLines( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set,
	    pts, 2, CoordModeOrigin );
XBFlush( XBWin );
}
