#ifndef lint
static char SCCSid[] = "@(#) ./system/fargs.c 07/23/93";
#endif

#include "tools.h"

/* 
   This file contains code to allow Fortran program to access the command line
   with the usual SY routines (note that since argv and argc are not available
   to the Fortran programmer, we provide them.
 */

static char **Argv;
static int  Argc;

/*@ 
    SYArgLoad - Loads the command line arguments for Fortran programs

    Output Parameters:
.   argc,argv - values to be passed to the SYArgxxx routines

    Notes:
    This is intended as a Fortran-only interface.  
    Note that since this does NOT consume the args, it is not necessary to
    load it once.
@*/
void SYArgLoad( argc, argv  )
int  *argc;
int  *argv;
{
int  i, argsize = 40;
char *p;

/* Recover the args with the Fortran routines iargc_ and getarg_ */
Argc = iargc_() + 1;
Argv = (char **)MALLOC( Argc * sizeof(char *) );     CHKPTR(Argv);
for (i=0; i<Argc; i++) {
    Argv[i] = (char *)MALLOC( argsize + 1 );         CHKPTR(Argv[i]);
    getarg_( &i, Argv[i], argsize );
    /* Trim trailing blanks */
    p = Argv[i] + argsize - 1;
    while (p > Argv[i]) {
	if (*p != ' ') {
	    p[1] = '\0';
	    break;
	    }
	p--;
	}
    }
*argc = Argc;
*argv = (int)Argv;
}

/* Note that this doesn't work if argv is modified. */
/*@
  SYArgFree - Frees the space allocated by SYArgLoad
@*/
void SYArgFree()
{
int i;
for (i=0; i<Argc; i++) {
    if (Argv[i]) FREE( Argv[i] );
    }
FREE( Argv );
}
