/* @(#) ./sparse/pool.h 07/23/93 */

/*
   Because a common use of these sparse routines is to allocate a 
   lot of sparse vectors (one for each row/column of a matrix),
   it is important to provide alternate methods (besides a malloc
   for each vector) of allocating space.  

   In order to provide a way to free this space, each allocated block
   includes a count of the number of elements that have been allocated
   but not freed.  When this count reaches zero, the block itself may
   be freed.
 */

#ifndef _STORAGE_POOL

/* The choice of BASIC_CHUNCK depends on the particular implementation of
   malloc being used.  This definition attempts to pick a size that
   will be just shy of a power of two for common sizes of doubles/ints.
   That leaves a little room for size information and will probably have
   the smallest fragment size 
 */
/* IMPORTANT: BASIC_CHUNCK_IN_BYTES-sizeof(SPBlock) must be divisible
              by (sizeof(double)+sizeof(int))!!! This is bad!
*/
#if defined(intelnx)
#define BASIC_CHUNCK_IN_BYTES 4*8192
#else
#define BASIC_CHUNCK_IN_BYTES 8192
#endif
#define BASIC_CHUNCK ((BASIC_CHUNCK_IN_BYTES-sizeof(SPBlock))/(sizeof(double)+sizeof(int)))
struct __Storage {
    double           *ptr;   /* Pointer to first free member of block */
    long             n;      /* Remaining "units" (double+int) in block */
    struct __Storage *next;
    };
typedef struct __Storage SPStorage;
/* Careful with the definition of SPBlock; it must be double-aligned */
struct __Block {
    long           n,         /* Number of bytes in block */
                   nalloc;    /* Number of allocated blocks */
    struct __Block *next, *last;
    };
typedef struct __Block SPBlock;

typedef struct {
    unsigned int  chunck_size; /* min storage to allocate (units) */
    SPStorage     pool;        /* Available storage */
    SPBlock       *free;       /* Freed subblocks */
    SPBlock       *alloc;      /* Actually allocated storage */
    } SPPool;

extern int SPInitPool(), SPPoolAllocNV(), SPPoolSize();
extern void SPPoolFree(), SPPoolFreeNV();
#define _STORAGE_POOL
#endif
