C----- SUBROUTINE RCM
C***************************************************************           1.
C***************************************************************           2.
C********     RCM ..... REVERSE CUTHILL-MCKEE ORDERING   *******           3.
C***************************************************************           4.
C***************************************************************           5.
C                                                                          6.
C     PURPOSE - RCM NUMBERS A CONNECTED COMPONENT SPECIFIED BY             7.
C        MASK AND ROOT, USING THE RCM ALGORITHM.                           8.
C        THE NUMBERING IS TO BE STARTED AT THE NODE ROOT.                  9.
C                                                                         10.
C     INPUT PARAMETERS -                                                  11.
C        ROOT - IS THE NODE THAT DEFINES THE CONNECTED                    12.
C               COMPONENT AND IT IS USED AS THE STARTING                  13.
C               NODE FOR THE RCM ORDERING.                                14.
C        (XADJ, ADJNCY) - ADJACENCY STRUCTURE PAIR FOR                    15.
C               THE GRAPH.                                                16.
C                                                                         17.
C     UPDATED PARAMETERS -                                                18.
C        MASK - ONLY THOSE NODES WITH NONZERO INPUT MASK                  19.
C               VALUES ARE CONSIDERED BY THE ROUTINE.  THE                20.
C               NODES NUMBERED BY RCM WILL HAVE THEIR                     21.
C               MASK VALUES SET TO ZERO.                                  22.
C                                                                         23.
C     OUTPUT PARAMETERS -                                                 24.
C        PERM - WILL CONTAIN THE RCM ORDERING.                            25.
C        CCSIZE - IS THE SIZE OF THE CONNECTED COMPONENT                  26.
C               THAT HAS BEEN NUMBERED BY RCM.                            27.
C                                                                         28.
C     WORKING PARAMETER -                                                 29.
C        DEG - IS A TEMPORARY VECTOR USED TO HOLD THE DEGREE              30.
C               OF THE NODES IN THE SECTION GRAPH SPECIFIED               31.
C               BY MASK AND ROOT.                                         32.
C                                                                         33.
C     PROGRAM SUBROUTINES -                                               34.
C        DEGREE.                                                          35.
C                                                                         36.
C***************************************************************          37.
C                                                                         38.
      SUBROUTINE  RCM ( ROOT, XADJ, ADJNCY, MASK,                         39.
     1                  PERM, CCSIZE, DEG )                               40.
C                                                                         41.
C***************************************************************          42.
C                                                                         43.
         INTEGER ADJNCY(1), DEG(1), MASK(1), PERM(1)                      44.
         INTEGER XADJ(1), CCSIZE, FNBR, I, J, JSTOP,                      45.
     1           JSTRT, K, L, LBEGIN, LNBR, LPERM,                        46.
     1           LVLEND, NBR, NODE, ROOT                                  47.
C                                                                         48.
C***************************************************************          49.
C                                                                         50.
C        -------------------------------------                            51.
C        FIND THE DEGREES OF THE NODES IN THE                             52.
C        COMPONENT SPECIFIED BY MASK AND ROOT.                            53.
C        -------------------------------------                            54.
         CALL  DEGREE ( ROOT, XADJ, ADJNCY, MASK, DEG,                    55.
     1                  CCSIZE, PERM )                                    56.
         MASK(ROOT) = 0                                                   57.
         IF ( CCSIZE .LE. 1 ) RETURN                                      58.
         LVLEND = 0                                                       59.
         LNBR = 1                                                         60.
C        --------------------------------------------                     61.
C        LBEGIN AND LVLEND POINT TO THE BEGINNING AND                     62.
C        THE END OF THE CURRENT LEVEL RESPECTIVELY.                       63.
C        --------------------------------------------                     64.
  100    LBEGIN = LVLEND + 1                                              65.
         LVLEND = LNBR                                                    66.
         DO 600 I = LBEGIN, LVLEND                                        67.
C           ----------------------------------                            68.
C           FOR EACH NODE IN CURRENT LEVEL ...                            69.
C           ----------------------------------                            70.
            NODE = PERM(I)                                                71.
            JSTRT = XADJ(NODE)                                            72.
            JSTOP = XADJ(NODE+1) - 1                                      73.
C           ------------------------------------------------              74.
C           FIND THE UNNUMBERED NEIGHBORS OF NODE.                        75.
C           FNBR AND LNBR POINT TO THE FIRST AND LAST                     76.
C           UNNUMBERED NEIGHBORS RESPECTIVELY OF THE CURRENT              77.
C           NODE IN PERM.                                                 78.
C           ------------------------------------------------              79.
            FNBR = LNBR + 1                                               80.
            DO 200 J = JSTRT, JSTOP                                       81.
               NBR = ADJNCY(J)                                            82.
               IF ( MASK(NBR) .EQ. 0 )  GO TO 200                         83.
                  LNBR = LNBR + 1                                         84.
                  MASK(NBR) = 0                                           85.
                  PERM(LNBR) = NBR                                        86.
  200       CONTINUE                                                      87.
            IF ( FNBR .GE. LNBR )  GO TO 600                              88.
C              ------------------------------------------                 89.
C              SORT THE NEIGHBORS OF NODE IN INCREASING                   90.
C              ORDER BY DEGREE. LINEAR INSERTION IS USED.                 91.
C              ------------------------------------------                 92.
               K = FNBR                                                   93.
  300          L = K                                                      94.
                  K = K + 1                                               95.
                  NBR = PERM(K)                                           96.
  400             IF ( L .LT. FNBR )  GO TO 500                           97.
                     LPERM = PERM(L)                                      98.
                     IF ( DEG(LPERM) .LE. DEG(NBR) )  GO TO 500           99.
                        PERM(L+1) = LPERM                                100.
                        L = L - 1                                        101.
                        GO TO 400                                        102.
  500             PERM(L+1) = NBR                                        103.
                  IF ( K .LT. LNBR )  GO TO 300                          104.
  600    CONTINUE                                                        105.
         IF (LNBR .GT. LVLEND) GO TO 100                                 106.
C        ---------------------------------------                         107.
C        WE NOW HAVE THE CUTHILL MCKEE ORDERING.                         108.
C        REVERSE IT BELOW ...                                            109.
C        ---------------------------------------                         110.
         K = CCSIZE/2                                                    111.
         L = CCSIZE                                                      112.
         DO 700 I = 1, K                                                 113.
            LPERM = PERM(L)                                              114.
            PERM(L) = PERM(I)                                            115.
            PERM(I) = LPERM                                              116.
            L = L - 1                                                    117.
  700    CONTINUE                                                        118.
         RETURN                                                          119.
      END                                                                120.
