#ifndef lint
static char SCCSid[] = "@(#) ./sparse/fblock/ftoblk.c 07/23/93";
#endif

/*
   This file contains routines to convert to and from the block format.
   This will allocate space from the pool for the copy; note that the
   organization of this blocked data structure allows the user to provide all
   of the storage areas
 */

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"
#include "sparse/fblock/spfbpriv.h"    
#include "inline/copy.h"
#include "inline/setval.h"

/* Linked list management routines/macros for sparse matrices.
   There are nc elements in the list, and the "head" is list[nc].
   list[nc]==nc for an empty list 

   These hold JUST the block indices; UNPACKLISTB unpacks into a
   full column index list.
 */
#define FINDLOC(list,loc,lastloc) \
    while (lastloc < loc) { _m = lastloc; lastloc = list[_m]; }
#define INSERTFROMLAST(list,nc,loc,lastloc,nzl) \
    { int _m=nc; FINDLOC(list,loc,lastloc) if (lastloc != loc) {\
    list[_m] = loc; list[loc] = lastloc; lastloc = loc; nzl++; }}
#define UNPACKLIST(list,nc,nzl,vi) \
{ int loc, l; loc = list[nc]; for (l=0; l<nzl; l++) {\
 vi[l] = loc; loc = list[loc]; } }
#define UNPACKLISTB(list,nc,nzl,vi) \
{ int loc, ll, kk; loc = list[nc]; for (ll=0; ll<nzl; ll++) {\
 for(kk=0; kk<bsize;kk++){\
 vi[kk+ll*bsize] = kk+loc*bsize;} loc = list[loc]; } }

/*@
    SpFBToBlk - Convert a matrix to block format with a given block size

    Input paramters:
.   mat   - matrix to convert
.   bsize - block size to use
 
    Returns:
    matrix in block format 

    Note the the sizes of mat (rows and columns) must be a multiple of 
    bsize.
@*/
SpMat *SpFBToBlk( mat, bsize )
SpMat *mat;
int   bsize;
{
SpMat      *new;
int        nr, nc, k;
int        i, ib, j, l, nzl, b2, *list, *iy, ny, *vi, loc, lastloc;
double     *rlist, *vp, *v, *p, *p2, *vy, *vb;
extern double *SPiPoolAlloc();
SpRowMat   *R;
SpFBRowMat *RB;

nr = mat->rows;
nc = mat->cols;
if ((nr % bsize) != 0 || (nc % bsize) != 0) {
    SETERRC(1,"Block size does not evenly divide matrix size"); return 0;}
nr /= bsize;
nc /= bsize;

new = SpFBCreate( mat->rows, mat->cols, 0, bsize );       CHKPTRN(new);

/* 
   Now, run through the matrix and discover the blocks.
   We use a linked list of blocks where there is one entry for
   each block 
 */

R     = GETROWMAT(mat);
RB    = GETBROWMAT(new);
nr    = mat->rows;
b2    = bsize * bsize;
list  = (int *)MALLOC( (nc + 1) * sizeof(int) );         CHKPTRN(list);
rlist = (double *)MALLOC( b2 * nc * sizeof(double) );    CHKPTRN(rlist);
i     = b2*nc;
for (l=0; l<i; l++)  rlist[l] = 0.0;
for (l=0; l<nc; l++)  list[l] = -1;

ib = 0;
for (i=0; i<nr; i += bsize) {
    /* Find all of the column blocks in this block of rows */
    list[nc] = nc;
    nzl      = 0;
    lastloc  = nc;
    for (j=i; j<i+bsize; j++) {
	iy = R->rs[j]->i;
	ny = R->rs[j]->nz;
	vy = R->rs[j]->v;
	for (l=0; l<ny; l++) {
	    loc = iy[l];
	    rlist[loc * bsize + (j-i)] = vy[l];
	    loc = loc / bsize;
	    INSERTFROMLAST(list,nc,loc,lastloc,nzl);
	    }
	lastloc = list[nc];
	}

    /* allocate and copy data into the block. */
    vp = SPiPoolAlloc( &new->pool, 
		       nzl * (b2 * sizeof(double) + bsize * sizeof(int)) );
    CHKPTRN(vp);
    vi = (int *)( vp + nzl * b2 );

    /* Copy the adjusted columns */
    UNPACKLISTB(list,nc,nzl,vi);
    
    /* Copy the values (note the Fortran ordering of the data; this
       allows us to use the level-2 and -3 blas with these matrices) */
    for (l=0; l<nzl; l++) {
	p  = rlist + vi[l]*b2;
	p2 = vp + l * b2;
	COPY(p2,p,b2);
	SET(p,b2,0.0);
	}

    RB->rs[ib]->nz = nzl;
    RB->rs[ib]->i  = vi;
    RB->rs[ib]->v  = vp;
    ib++;
    }
FREE( list );
FREE( rlist );
return new;
}
