#ifndef LINT
static char SCCSid[] = "@(#) ./sparse/diag/dprint.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"
#include "sparse/diag/diag.h"
#include <stdio.h>                       /*I <stdio.h> I*/

/*@
  SpDPrint - Print the elements of a sparse matrix stored in 
                    diagonal format

  Input parameters:
. fd  - FILE pointer
. mat - diagonal format matrix
 @*/
void SpDPrint( fd, nmat )
FILE  *fd;
SpMat *nmat;
{
SpMatDiag *mat = (SpMatDiag *)nmat->data;
SpDiag    *csd, **sd = mat->sd;
int       nsd = mat->nsd;
int       nd, nnr, nr, *doff, sr, i, j, ndpass;
int       rinc, dinc;    /* rinc and dinc are alias-free */
double    *dv, *d0, *d1, *d2, *d3, *d4, 
          **pdv;
double    a0, a1, a2, a3, a4;

while (nsd--) {
    csd = *sd++;
    nd  = csd->nd;
    nr  = csd->nr;
    doff= csd->doff;
    pdv = csd->v;
    rinc= csd->rinc;
    dinc= csd->dinc;
    sr  = csd->sr;
    fprintf( fd, "Diagonal starting at row %d with rinc = %d and dinc = %d\n",
	     sr, rinc, dinc );
    nnr = nr;
    switch (csd->kind) {
	case DIAG_UNITSTRIDE:
	case DIAG_GENERAL:
	while (nd > 0) {
	    nnr = nr;
	    ndpass = (nd > 5) ? 5 : nd;
	    d0  = pdv[0]; d1  = pdv[1]; d2  = pdv[2]; d3  = pdv[3];
	    d4  = pdv[4]; pdv += 5;
	    
	    for (i=0; i<ndpass; i++) 
		fprintf( fd, "%13d ", doff[i] );
	    fputs( "\n", fd );
	    doff += 5;
	    switch (ndpass) {
		case 5: while (nnr--) {
		    fprintf( fd, "%13e %13e %13e %13e %13e\n", *d0, *d1, *d2,
			     *d3, *d4 ); d0+=dinc;d1+=dinc;d2+=dinc;d3+=dinc;
		    d4+=dinc;}break;
		case 4: while (nnr--) {
		    fprintf( fd, "%13e %13e %13e %13e\n", *d0, *d1, *d2,
			     *d3 ); d0+=dinc;d1+=dinc;d2+=dinc;d3+=dinc;
		    }break;
		case 3: while (nnr--) {
		    fprintf( fd, "%13e %13e %13e\n", *d0, *d1, *d2 ); 
		    d0+=dinc;d1+=dinc;d2+=dinc; }break;
		case 2: while (nnr--) {
		    fprintf( fd, "%13e %13e\n", *d0, *d1 ); 
		    d0+=dinc;d1+=dinc; }break;
		case 1: while (nnr--) {
		    fprintf( fd, "%13e\n", *d0 );  d0+=dinc;}break;
		}
	    nd -= 5;
	    }
	break;

	case DIAG_CONSTANT:
	dv  = (double *)pdv;
	fprintf( fd, "[%d] rows\n", nr );
	while (nd > 0) {
	    nnr = nr;
	    a0  = dv[0]; a1 = dv[1]; a2 = dv[2]; a3 = dv[3]; 
	    a4 = dv[4]; dv += 5;
	    switch ((nd > 5) ? 5 : nd) {
		case 5: 
		fprintf( fd, "%13d %13d %13d %13d %13d\n", 
			 doff[0], doff[1], doff[2], doff[3], doff[4] );
		    fprintf( fd, "%13e %13e %13e %13e %13e\n", a0, a1, a2, a3,
			     a4 );break;
		case 4: 
		fprintf( fd, "%13d %13d %13d %13d\n", doff[0], doff[1], 
			     doff[2], doff[3] );
		    fprintf( fd, "%13e %13e %13e %13e\n", a0, a1, a2, a3 );
		    break;
		case 3:
		fprintf( fd, "%13d %13d %13d\n", doff[0], doff[1], doff[2] );
		    fprintf( fd, "%13e %13e %13e\n", a0, a1, a2 );break;
		case 2:
		fprintf( fd, "%13d %13d\n", doff[0], doff[1] );
		    fprintf( fd, "%13e %13e\n", a0, a1 );break;
		case 1: 
		fprintf( fd, "%13d\n", doff[0] );
		    fprintf( fd, "%13e\n", a0 );break;
		}
	    nd -= 5;
	    doff += 5;
	    }
	}
    }
}

