/*
   A program to test sparse matrix reordering for zero diagonals
 */

#include <stdio.h>
#include <math.h>
#include "tools.h"
#include "solvers/svctx.h"

/* Forward references */
void CompareSolution();

main( argc, argv )
int  argc;
char **argv;
{
int        i,n, err = 0;
SpMat      *mat;
SpMatSplit *factor;
double     *v, *vsol;
SVctx      *ctx;
int        its;
ITMETHOD   method = ITTFQMR;
int        kk, ptype;

n     = 4;
v   = (double *)MALLOC( (5 * sizeof(double)) );
vsol= (double *)MALLOC( (5 * sizeof(double)) );
for (i=0; i<n; i++) vsol[i] = 1.0;

/* Create a matrix with 0 diagonal entries */
mat = SpCreate( 4, 4, 2 );
SpAddValue( mat, 1.0, 0, 1 );
SpAddValue( mat, 1.0, 1, 0 );
SpAddValue( mat, 1.0, 0, 2 );
SpAddValue( mat, 1.0, 2, 0 );
SpAddValue( mat, -1.0, 1, 3 );
SpAddValue( mat, -1.0, 3, 1 );
SpAddValue( mat, 2.0, 2, 2 );
SpAddValue( mat, 2.0, 3, 3 );
SpMult( mat, vsol, v );

for (kk=0; kk<2; kk++) {
  if (kk == 0) {
      ptype = PIVOT_PRE_SYM;
      printf( "Symmetric pivoting\n" );
      }
  else {
      ptype = PIVOT_PRE_NONSYM;
      printf( "Nonsymmetric pivoting\n" );
      }

  ctx = SVCreate(mat,SVLU);             CHKERR(1);
  /* SVSetLUOrdering(ctx,ORDER_RCM);     */
  SVSetLUOrdering(ctx,-1);    
  SVSetLUPivoting( ctx, ptype );
  SVSetUp(ctx);                                            CHKERR(1);
  SVSolve(ctx,v,vsol);                CHKERR(1);
  printf( "Direct factorization\n" );
  CompareSolution( vsol, n );
  SVDestroy(ctx);                                          CHKERR(1);

  ctx = SVCreate(mat,SVILU);CHKERR(1);
  SVSetAccelerator(ctx,method);
  for (i=0; i<n; i++) vsol[i] = 0.0;
  SVSetILUFill(ctx,0);
  SVSetILUPivoting( ctx, ptype );
  SVSetUp(ctx);                                            CHKERR(1);
  SVSetIts(ctx,10*8);
  SVSetRelativeTol(ctx,1.0e-6);
  SVSetGMRESRestart(ctx,2*10);
  its = SVSolve(ctx,v,vsol);           CHKERR(1);
  printf( "ILU factorization (%d)\n", its );
  CompareSolution( vsol, n );
  SVDestroy(ctx);                                          CHKERR(1);
  }

SpDestroy( mat );

/* Create a matrix with 0 diagonal entries */
printf( "Unsymmetric ordering only\n" );
mat = SpCreate( 4, 4, 2 );
SpAddValue( mat, 1.0, 0, 1 );
SpAddValue( mat, 1.0, 1, 0 );
SpAddValue( mat, 2.0, 2, 2 );
SpAddValue( mat, 2.0, 3, 3 );
SpMult( mat, vsol, v );

  ctx = SVCreate(mat,SVLU);             CHKERR(1);
  /* SVSetLUOrdering(ctx,ORDER_RCM);     */
  SVSetLUOrdering(ctx,-1);    
  SVSetLUPivoting( ctx, PIVOT_PRE_NONSYM );
  SVSetUp(ctx);                                            CHKERR(1);
  SVSolve(ctx,v,vsol);                CHKERR(1);
  printf( "Direct factorization\n" );
  CompareSolution( vsol, n );
  SVDestroy(ctx);                                          CHKERR(1);

  ctx = SVCreate(mat,SVILU);CHKERR(1);
  SVSetAccelerator(ctx,method);
  for (i=0; i<n; i++) vsol[i] = 0.0;
  SVSetILUFill(ctx,0);
  SVSetILUPivoting( ctx, PIVOT_PRE_NONSYM );
  SVSetUp(ctx);                                            CHKERR(1);
  SVSetIts(ctx,10*8);
  SVSetRelativeTol(ctx,1.0e-6);
  SVSetGMRESRestart(ctx,2*10);
  its = SVSolve(ctx,v,vsol);           CHKERR(1);
  printf( "ILU factorization (%d)\n", its );
  CompareSolution( vsol, n );
  SVDestroy(ctx);                                          CHKERR(1);
SpDestroy( mat );

n     = 5;
for (i=0; i<n; i++) vsol[i] = 1.0;

/* Sample from user */
printf ("Constraint matrix example\n" );
mat = SpCreate( 5, 5, 3 );
SpAddValue( mat, 1.0, 0, 0 );
SpAddValue( mat, 1.0, 0, 3 );
SpAddValue( mat, -3.0, 0, 4 );
SpAddValue( mat, 1.0, 1, 1 );
SpAddValue( mat, 8.0, 1, 4 );
SpAddValue( mat, 1.0, 2, 2 );
SpAddValue( mat, -5.0, 2, 4 );
SpAddValue( mat, 1.0, 3, 0 );
SpAddValue( mat, -3.0, 4, 0 );
SpAddValue( mat, 8.0, 4, 1 );
SpAddValue( mat, -5.0, 4, 2 );
SpMult( mat, vsol, v );

  ctx = SVCreate(mat,SVLU);             CHKERR(1);
  /* SVSetLUOrdering(ctx,ORDER_RCM);     */
  SVSetLUOrdering(ctx,-1);    
  SVSetLUPivoting( ctx, PIVOT_PRE_NONSYM );
  SVSetUp(ctx);                                            CHKERR(1);
  SVSolve(ctx,v,vsol);                CHKERR(1);
  printf( "Direct factorization\n" );
  CompareSolution( vsol, n );
  SVDestroy(ctx);                                          CHKERR(1);

  ctx = SVCreate(mat,SVILU);CHKERR(1);
  SVSetAccelerator(ctx,method);
  for (i=0; i<n; i++) vsol[i] = 0.0;
  SVSetILUFill(ctx,0);
  SVSetILUPivoting( ctx, PIVOT_PRE_NONSYM );
  SVSetUp(ctx);                                            CHKERR(1);
  SVSetIts(ctx,10*8);
  SVSetRelativeTol(ctx,1.0e-6);
  SVSetGMRESRestart(ctx,2*10);
  its = SVSolve(ctx,v,vsol);           CHKERR(1);
  printf( "ILU factorization (%d)\n", its );
  CompareSolution( vsol, n );
  SVDestroy(ctx);                                          CHKERR(1);
SpDestroy( mat );

/* Free space */
FREE(v);
FREE(vsol);
/* These are necessary ONLY to recover the rest of the allocated space */
ITRegisterDestroy();
SpOrderRegisterDestroy();

/* Here is some code to print the memory usage */
{int s, f;
TRSPACE(&s,&f);
printf( "Memory allocated = %d in %d blocks\n", s, f );
printf( "List of blocks is\n" );
TRDUMP(stdout);
 }
return 0;
}

void CompareSolution( v, n )
register double *v;
register n;
{
register double sum = 0.0;
while (n--) {
    sum += (*v - 1.0) * (*v - 1.0);
    v++;
    }
printf( "Difference in 2-norm is %f\n", sum );
}

